/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.nt;

import java.util.Vector;
import org.alfresco.jlan.smb.nt.RID;

public class RIDList {
    private Vector<RID> m_list = new Vector();

    public final void addRID(RID rid) {
        this.m_list.add(rid);
    }

    public final void addRIDs(RIDList list) {
        if (list != null && list.numberOfRIDs() > 0) {
            for (int i = 0; i < list.numberOfRIDs(); ++i) {
                this.addRID(list.getRIDAt(i));
            }
        }
    }

    public final RID getRIDAt(int idx) {
        if (idx < 0 || idx >= this.m_list.size()) {
            return null;
        }
        return this.m_list.get(idx);
    }

    public final int numberOfRIDs() {
        return this.m_list.size();
    }

    public final RID findRID(String name, int typ) {
        for (int i = 0; i < this.m_list.size(); ++i) {
            RID curRID = this.m_list.get(i);
            if (curRID.isType() != typ || !curRID.getName().equals(name)) continue;
            return curRID;
        }
        return null;
    }

    public final RID findRID(int id, int typ) {
        for (int i = 0; i < this.m_list.size(); ++i) {
            RID curRID = this.m_list.get(i);
            if (curRID.getRID() != id || curRID.isType() != typ) continue;
            return curRID;
        }
        return null;
    }

    public final RID findRID(int id) {
        for (int i = 0; i < this.m_list.size(); ++i) {
            RID curRID = this.m_list.get(i);
            if (curRID.getRID() != id) continue;
            return curRID;
        }
        return null;
    }

    public final RID removeRID(int id) {
        for (int i = 0; i < this.m_list.size(); ++i) {
            RID curRID = this.m_list.get(i);
            if (curRID.getRID() != id) continue;
            this.m_list.removeElementAt(i);
            return curRID;
        }
        return null;
    }

    public final void removeAllRIDs() {
        this.m_list.removeAllElements();
    }

    public final int[] getIdList() {
        int[] ids = new int[this.m_list.size()];
        for (int i = 0; i < this.m_list.size(); ++i) {
            RID rid = this.m_list.get(i);
            ids[i] = rid.getRID();
        }
        return ids;
    }
}

