/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.pseudo;

import java.io.IOException;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.LocalFileState;
import org.alfresco.jlan.server.filesys.cache.NetworkFileStateInterface;

public class MemoryNetworkFile
extends NetworkFile
implements NetworkFileStateInterface {
    private long m_filePos;
    private byte[] m_data;
    private FileState m_state;

    public MemoryNetworkFile(String name, byte[] data, FileInfo finfo) {
        super(name);
        this.m_data = data;
        if (this.m_data == null) {
            this.m_data = new byte[0];
        }
        this.setFileSize(this.m_data.length);
        this.setModifyDate(finfo.getModifyDateTime());
        this.setCreationDate(finfo.getCreationDateTime());
        if (finfo.getPath() != null) {
            this.setFileId(finfo.getPath().hashCode());
            this.setFullName(finfo.getPath());
        }
    }

    @Override
    public void closeFile() throws IOException {
        this.m_state = null;
    }

    public long currentPosition() {
        return this.m_filePos;
    }

    @Override
    public void flushFile() throws IOException {
    }

    public boolean isEndOfFile() throws IOException {
        return this.m_filePos == (long)this.m_data.length;
    }

    @Override
    public void openFile(boolean createFlag) throws IOException {
        this.setClosed(false);
    }

    @Override
    public int readFile(byte[] buf, int len, int pos, long fileOff) throws IOException {
        long fileLen = this.m_data.length;
        if (fileOff >= fileLen) {
            return 0;
        }
        if (fileOff + (long)len > fileLen) {
            len = (int)(fileLen - fileOff);
        }
        System.arraycopy(this.m_data, (int)fileOff, buf, pos, len);
        this.m_filePos = fileOff + (long)len;
        return len;
    }

    @Override
    public long seekFile(long pos, int typ) throws IOException {
        switch (typ) {
            case 0: {
                if (this.currentPosition() == pos) break;
                this.m_filePos = pos;
                break;
            }
            case 1: {
                this.m_filePos += pos;
                break;
            }
            case 2: {
                this.m_filePos += pos;
                if (this.m_filePos >= 0L) break;
                this.m_filePos = 0L;
            }
        }
        return this.currentPosition();
    }

    @Override
    public void truncateFile(long siz) throws IOException {
    }

    public void writeFile(byte[] buf, int len, int pos) throws IOException {
    }

    @Override
    public void writeFile(byte[] buf, int len, int pos, long offset) throws IOException {
    }

    @Override
    public FileState getFileState() {
        if (this.m_state == null) {
            this.m_state = new LocalFileState(this.getFullName(), false);
        }
        return this.m_state;
    }
}

