/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.loader;

public class MemorySegment {
    private byte[] m_buffer;
    private long m_fileOff;
    private int m_readCount;

    public MemorySegment(byte[] buf, long fileOff) {
        this.m_buffer = buf;
        this.m_fileOff = fileOff;
    }

    public MemorySegment(byte[] buf, int pos, int len, long fileOff) {
        this.m_buffer = new byte[len];
        System.arraycopy(buf, pos, this.m_buffer, 0, len);
        this.m_fileOff = fileOff;
    }

    public final byte[] getBuffer() {
        return this.m_buffer;
    }

    public final int getLength() {
        return this.m_buffer.length;
    }

    public final long getFileOffset() {
        return this.m_fileOff;
    }

    public final int getReadCounter() {
        return this.m_readCount;
    }

    public final boolean containsData(long fileOff, int len) {
        if (len > this.getLength()) {
            return false;
        }
        long endOff = fileOff + (long)len;
        long dataEnd = this.getFileOffset() + (long)this.getLength();
        return fileOff >= this.getFileOffset() && endOff <= dataEnd;
    }

    public final void copyBytes(byte[] buf, int pos, int len, long fileOff) {
        int bufOff = (int)(fileOff - this.getFileOffset());
        System.arraycopy(this.m_buffer, bufOff, buf, pos, len);
        ++this.m_readCount;
    }

    public final void incrementReadCounter(int incr) {
        this.m_readCount += incr;
    }

    protected final void decrementReadCounter(int decr) {
        this.m_readCount = this.m_readCount > decr ? (this.m_readCount -= decr) : 0;
    }

    protected final void decrementReadCounter() {
        this.decrementReadCounter(1);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[len=");
        str.append(this.getLength());
        str.append(",fileOff=");
        str.append(this.getFileOffset());
        str.append(",reads=");
        str.append(this.getReadCounter());
        str.append("]");
        return str.toString();
    }
}

