/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.FileName;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.FileStateCache;
import org.alfresco.jlan.server.filesys.cache.FileStateListener;
import org.alfresco.jlan.server.filesys.cache.FileStateProxy;
import org.alfresco.jlan.server.filesys.db.BackgroundLoadSave;
import org.alfresco.jlan.server.filesys.db.CachedNetworkFile;
import org.alfresco.jlan.server.filesys.db.DBDataDetails;
import org.alfresco.jlan.server.filesys.db.DBDataDetailsList;
import org.alfresco.jlan.server.filesys.db.DBDataInterface;
import org.alfresco.jlan.server.filesys.db.DBDeviceContext;
import org.alfresco.jlan.server.filesys.db.DBException;
import org.alfresco.jlan.server.filesys.db.DBFileInfo;
import org.alfresco.jlan.server.filesys.db.DBNetworkFile;
import org.alfresco.jlan.server.filesys.db.DBQueueInterface;
import org.alfresco.jlan.server.filesys.db.DirectoryNetworkFile;
import org.alfresco.jlan.server.filesys.loader.BackgroundFileLoader;
import org.alfresco.jlan.server.filesys.loader.CachedFileInfo;
import org.alfresco.jlan.server.filesys.loader.FileLoader;
import org.alfresco.jlan.server.filesys.loader.FileLoaderException;
import org.alfresco.jlan.server.filesys.loader.FileProcessor;
import org.alfresco.jlan.server.filesys.loader.FileProcessorList;
import org.alfresco.jlan.server.filesys.loader.FileRequest;
import org.alfresco.jlan.server.filesys.loader.FileRequestQueue;
import org.alfresco.jlan.server.filesys.loader.FileSegment;
import org.alfresco.jlan.server.filesys.loader.FileSegmentInfo;
import org.alfresco.jlan.server.filesys.loader.MultipleFileRequest;
import org.alfresco.jlan.server.filesys.loader.SingleFileRequest;
import org.alfresco.jlan.util.MemorySize;
import org.springframework.extensions.config.ConfigElement;

public class DBFileLoader
implements FileLoader,
BackgroundFileLoader,
FileStateListener {
    public static final int StsSuccess = 0;
    public static final int StsRequeue = 1;
    public static final int StsError = 2;
    public static final String TempDirPrefix = "ldr";
    public static final String TempFilePrefix = "ldr_";
    public static final String JarFilePrefix = "jar_";
    private static final int MaximumFilesPerSubDir = 500;
    public static final String DBFileSegmentInfo = "DBFileSegmentInfo";
    public static final int DefaultWorkerThreads = 4;
    public static final int MinimumWorkerThreads = 1;
    public static final int MaximumWorkerThreads = 50;
    public static final int DefaultFilesPerJar = 25;
    public static final int MinimumFilesPerJar = 5;
    public static final int DefaultSizePerJar = 200000;
    public static final int MinimumSizePerJar = 100000;
    public static final long SequentialFileExpire = 3000L;
    public static final long RequestProcessedExpire = 3000L;
    public static final long RequestQueuedExpire = 10000L;
    public static final int TransactionMinimumFileSize = 1024;
    public static final long DefaultTransactionTimeout = 5000L;
    public static final long MinimumTransactionTimeout = 2000L;
    public static final long MaximumTransactionTimeout = 60000L;
    public static final long DEFAULT_FRAGSIZE = 524288L;
    public static final long MIN_FRAGSIZE = 65536L;
    public static final long MAX_FRAGSIZE = 0x40000000L;
    public static final long MAX_MEMORYBUFFER = 524288L;
    public static final String JarStatePrefix = "**JAR";
    public static final long JarStateTimeout = 300000L;
    public static final int JarDefaultCompression = 0;
    private String m_name;
    private int m_maxQueueSize;
    private int m_lowQueueSize;
    private boolean m_debug;
    private boolean m_threadDebug;
    private int m_readWorkers;
    private int m_writeWorkers;
    private long m_smallFileSize;
    private int m_filesPerJar;
    private int m_sizePerJar;
    private DBDeviceContext m_dbCtx;
    private FileStateCache m_stateCache;
    private DBDataInterface m_dbDataInterface;
    private BackgroundLoadSave m_backgroundLoader;
    private long m_fragSize = 524288L;
    private boolean m_keepJars;
    private int m_jarCompressLevel;
    private String m_tempDirName;
    private File m_tempDir;
    private String m_tempDirPrefix = "ldr";
    private String m_tempFilePrefix = "ldr_";
    private String m_curTempName;
    private File m_curTempDir;
    private int m_curTempIdx;
    private int m_tempCount;
    private int m_tempMax;
    private int m_tranId;
    private int m_totFileSize;
    private int m_totFiles;
    private long m_lastTranFile;
    private Object m_tranLock = new Object();
    private long m_tranTimeout;
    private TransactionTimer m_transTimer;
    private FileProcessorList m_fileProcessors;

    @Override
    public int getRequiredDBFeatures() {
        return 28;
    }

    public final DBDeviceContext getContext() {
        return this.m_dbCtx;
    }

    public final int getJarCompressionLevel() {
        return this.m_jarCompressLevel;
    }

    protected final FileStateCache getStateCache() {
        return this.m_stateCache;
    }

    public final String getTemporaryDirectoryPath() {
        return this.m_tempDirName;
    }

    public final File getTemporaryDirectory() {
        return this.m_tempDir;
    }

    public final File getCurrentTempDirectory() {
        return this.m_curTempDir;
    }

    public final boolean hasKeepJars() {
        return this.m_keepJars;
    }

    public final DBDataInterface getDBDataInterface() {
        return this.m_dbDataInterface;
    }

    @Override
    public void addFileProcessor(FileProcessor fileProc) throws FileLoaderException {
        if (this.m_fileProcessors == null) {
            this.m_fileProcessors = new FileProcessorList();
        }
        this.m_fileProcessors.addProcessor(fileProc);
    }

    public final boolean hasFileProcessors() {
        return this.m_fileProcessors != null;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final int getMaximumQueueSize() {
        return this.m_maxQueueSize;
    }

    public final int getLowQueueSize() {
        return this.m_lowQueueSize;
    }

    public final String getName() {
        return this.m_name;
    }

    public final long getSmallFileSize() {
        return this.m_smallFileSize;
    }

    public final int getFilesPerJar() {
        return this.m_filesPerJar;
    }

    public final int getJarFileSize() {
        return this.m_sizePerJar;
    }

    public final long getTransactionTimeout() {
        return this.m_tranTimeout;
    }

    public final String getTempDirectoryPrefix() {
        return this.m_tempDirPrefix;
    }

    public final String getTempFilePrefix() {
        return this.m_tempFilePrefix;
    }

    protected final void setName(String name) {
        this.m_name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkFile openFile(FileOpenParams params, int fid, int stid, int did, boolean create, boolean dir) throws IOException, FileNotFoundException {
        String[] paths = FileName.splitPath(params.getPath());
        String name = paths[1];
        FileState fstate = this.m_stateCache.findFileState(params.getFullPath(), true);
        fstate.setExpiryTime(System.currentTimeMillis() + this.m_stateCache.getFileStateExpireInterval());
        DBNetworkFile netFile = null;
        if (!dir) {
            CachedNetworkFile cacheFile = this.createNetworkFile(fstate, params, name, fid, stid, did);
            netFile = cacheFile;
            FileSegment fileSeg = cacheFile.getFileSegment();
            if (create || params.isOverwrite()) {
                fileSeg.setStatus(3);
            } else if (params.isSequentialAccessOnly() && !fileSeg.isDataLoading()) {
                FileState fileState = cacheFile.getFileState();
                synchronized (fileState) {
                    cacheFile.openFile(create);
                    cacheFile.closeFile();
                    if (!fileSeg.isDataLoading()) {
                        this.queueFileRequest(new SingleFileRequest(0, cacheFile.getFileId(), cacheFile.getStreamId(), fileSeg.getInfo(), cacheFile.getFullNameStream(), fstate));
                    }
                }
                if (this.hasDebug()) {
                    Debug.println("## FileLoader Queued file load, SEQUENTIAL access");
                }
            }
        } else {
            netFile = new DirectoryNetworkFile(name, fid, did, this.m_stateCache.getFileStateProxy(fstate));
            netFile.setFullName(params.getPath());
            if (this.hasDebug()) {
                Debug.println("DBFileLoader.openFile() DIR state=" + fstate + ", netfile=" + netFile);
            }
        }
        return netFile;
    }

    @Override
    public void closeFile(SrvSession sess, NetworkFile netFile) throws IOException {
        if (netFile instanceof CachedNetworkFile) {
            CachedNetworkFile cacheFile = (CachedNetworkFile)netFile;
            cacheFile.closeFile();
            FileSegment fileSeg = cacheFile.getFileSegment();
            if (fileSeg.isUpdated() && !netFile.hasDeleteOnClose()) {
                File tempFile = new File(fileSeg.getTemporaryFile());
                netFile.setModifyDate(tempFile.lastModified());
                netFile.setFileSize(tempFile.length());
                if (!fileSeg.isSaveQueued()) {
                    this.m_stateCache.setDataUpdateInProgress(cacheFile.getFileState());
                    SingleFileRequest fileReq = new SingleFileRequest(1, cacheFile.getFileId(), cacheFile.getStreamId(), fileSeg.getInfo(), cacheFile.getFileState().getPath(), cacheFile.getFileState());
                    fileSeg.setStatus(4, true);
                    if (this.getSmallFileSize() > 0L && netFile.getFileSize() < this.getSmallFileSize()) {
                        this.createTransactionRequest(fileReq, netFile);
                    }
                    this.queueFileRequest(fileReq);
                } else if (this.hasDebug()) {
                    Debug.println("## FileLoader Save already queued for " + fileSeg);
                }
            } else if (cacheFile.getFileState().getOpenCount() == 0) {
                long tmo = System.currentTimeMillis();
                tmo = cacheFile.isSequentialOnly() ? (tmo += 3000L) : (tmo += this.m_stateCache.getFileStateExpireInterval());
                cacheFile.getFileState().setExpiryTime(tmo);
            }
        }
    }

    @Override
    public void deleteFile(String fname, int fid, int stid) throws IOException {
        block6: {
            try {
                block5: {
                    FileSegmentInfo fileSegInfo;
                    FileState fstate = this.m_stateCache.findFileState(fname, false);
                    if (fstate != null && (fileSegInfo = (FileSegmentInfo)fstate.removeAttribute(DBFileSegmentInfo)) != null) {
                        try {
                            fileSegInfo.deleteTemporaryFile();
                        }
                        catch (Exception ex) {
                            if (!this.hasDebug()) break block5;
                            Debug.println("## DBFileLoader failed to delete temp file " + fileSegInfo.getTemporaryFile());
                        }
                    }
                }
                this.getDBDataInterface().deleteFileData(fid, stid);
            }
            catch (Exception ex) {
                if (!this.hasDebug()) break block6;
                Debug.println("## DBFileLoader deleteFile() error, " + ex.toString());
            }
        }
    }

    @Override
    public void queueFileRequest(FileRequest req) {
        this.m_backgroundLoader.queueFileRequest(req);
    }

    @Override
    public int loadFile(FileRequest req) throws Exception {
        long startTime = 0L;
        SingleFileRequest loadReq = (SingleFileRequest)req;
        if (this.hasDebug()) {
            Debug.println("## DBFileLoader loadFile() req=" + loadReq.toString() + ", thread=" + Thread.currentThread().getName());
            startTime = System.currentTimeMillis();
        }
        File tempFile = new File(loadReq.getTemporaryFile());
        FileSegment fileSeg = this.findFileSegmentForPath(loadReq.getVirtualPath());
        if (!tempFile.exists() || fileSeg == null) {
            if (this.hasDebug()) {
                Debug.println("  Temporary file deleted");
            }
            fileSeg.setStatus(7, false);
            return 2;
        }
        Object fileOut = null;
        int loadSts = 1;
        try {
            fileSeg.setStatus(2);
            DBDataDetails dataDetails = this.getDBDataInterface().getFileDataDetails(loadReq.getFileId(), loadReq.getStreamId());
            if (this.hasDebug()) {
                Debug.println("  Data details: " + dataDetails);
            }
            if (dataDetails.isStoredInJar()) {
                loadSts = this.loadFileFromJar(loadReq, tempFile, dataDetails);
                fileSeg.setStatus(3, false);
                fileSeg.signalDataAvailable();
            } else {
                this.getDBDataInterface().loadFileData(loadReq.getFileId(), loadReq.getStreamId(), fileSeg);
                loadSts = 0;
                if (this.hasDebug()) {
                    long endTime = System.currentTimeMillis();
                    Debug.println("## DBFileLoader loaded fid=" + loadReq.getFileId() + ", stream=" + loadReq.getStreamId() + ", frags=" + dataDetails.numberOfDataFragments() + ", time=" + (endTime - startTime) + "ms");
                }
            }
        }
        catch (DBException ex) {
            if (this.hasDebug()) {
                Debug.println(ex);
            }
            loadSts = 2;
        }
        catch (IOException ex) {
            if (this.hasDebug()) {
                Debug.println(ex);
            }
            loadSts = 2;
        }
        if (loadSts == 0) {
            fileSeg.signalDataAvailable();
            fileSeg.setStatus(3, false);
            this.runFileLoadedProcessors(this.getContext(), loadReq.getFileState(), fileSeg);
        }
        return loadSts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int loadFileFromJar(SingleFileRequest loadReq, File tempFile, DBDataDetails dataDetails) {
        FileSegment jarSeg;
        int loadSts;
        block78: {
            loadSts = 2;
            String jarStateName = JarStatePrefix + dataDetails.getJarId();
            FileState jarState = this.getStateCache().findFileState(jarStateName);
            FileSegmentInfo segInfo = null;
            jarSeg = null;
            File jarFile = null;
            boolean loadJarReq = false;
            if (jarState == null) {
                jarFile = new File(this.getCurrentTempDirectory(), JarFilePrefix + dataDetails.getJarId() + ".jar");
                jarState = this.createFileStateForRequest(-2, jarFile.getAbsolutePath(), jarStateName, 1);
                jarState.setExpiryTime(System.currentTimeMillis() + 300000L);
                segInfo = new FileSegmentInfo(jarFile.getAbsolutePath());
                jarState.addAttribute(DBFileSegmentInfo, segInfo);
                jarSeg = new FileSegment(segInfo, true);
                loadJarReq = true;
                if (this.hasDebug()) {
                    Debug.println("Creating new state for Jar, jar=" + jarFile.getAbsolutePath());
                }
            } else {
                segInfo = (FileSegmentInfo)jarState.findAttribute(DBFileSegmentInfo);
                if (segInfo != null && segInfo.hasStatus() == 0) {
                    jarFile = new File(jarSeg.getTemporaryFile());
                    loadJarReq = true;
                    if (this.hasDebug()) {
                        Debug.println("Jar file state requires Jar load, state=Initial");
                    }
                } else if (jarSeg == null) {
                    FileState fileState = jarState;
                    synchronized (fileState) {
                        jarFile = new File(this.getCurrentTempDirectory(), dataDetails.getJarId() + ".jar");
                        segInfo = new FileSegmentInfo();
                        segInfo.setTemporaryFile(jarFile.getAbsolutePath());
                        jarSeg = new FileSegment(segInfo, true);
                        jarSeg.setStatus(1, true);
                        jarState.addAttribute(DBFileSegmentInfo, segInfo);
                    }
                    loadJarReq = true;
                    if (this.hasDebug()) {
                        Debug.println("Jar file segment created, load required");
                    }
                } else if (this.hasDebug()) {
                    Debug.println("jarSeg=" + jarSeg);
                }
            }
            if (loadJarReq) {
                try {
                    if (jarSeg.getLoadLock()) {
                        if (this.hasDebug()) {
                            Debug.println("Loading Jar, got load lock ...");
                        }
                        try {
                            this.getDBDataInterface().loadJarData(dataDetails.getJarId(), jarSeg);
                            jarSeg.setStatus(3, false);
                            loadSts = 0;
                            if (this.hasDebug()) {
                                Debug.println("## DBFileLoader JAR loaded " + loadReq.toString() + ", jarId=" + dataDetails.getJarId());
                            }
                            break block78;
                        }
                        catch (Exception ex) {
                            Debug.println(ex);
                            break block78;
                        }
                        finally {
                            FileState ex = jarState;
                            synchronized (ex) {
                                jarState.notifyAll();
                            }
                        }
                    }
                    if (jarSeg.hasStatus() == 3) {
                        loadSts = 0;
                        if (this.hasDebug()) {
                            Debug.println("Waited for load, threadId=" + loadReq.getThreadId());
                        }
                        break block78;
                    }
                    loadSts = 1;
                }
                catch (InterruptedException ex) {
                    loadSts = 1;
                }
            } else {
                jarState.setExpiryTime(System.currentTimeMillis() + 300000L);
                segInfo = (FileSegmentInfo)jarState.findAttribute(DBFileSegmentInfo);
                jarSeg = new FileSegment(segInfo, true);
                if (jarSeg.hasStatus() != 3) {
                    if (this.hasDebug()) {
                        Debug.println("## DBFileLoader Jar not yet available, " + jarSeg.getTemporaryFile());
                    }
                    int retryCnt = 0;
                    while (retryCnt++ < 50 && jarSeg.hasStatus() != 3) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException ex) {}
                    }
                    if (jarSeg.hasStatus() != 3) {
                        loadSts = 1;
                    } else if (this.hasDebug()) {
                        Debug.println("  Jar file loaded, waited " + 250 * retryCnt + "ms");
                    }
                } else {
                    loadSts = 0;
                    if (this.hasDebug()) {
                        Debug.println("## DBFileLoader Jar cache hit, re-using " + jarSeg.getTemporaryFile());
                    }
                }
            }
        }
        if (loadSts == 0) {
            JarFile jar = null;
            FileOutputStream outFile = null;
            InputStream jarIn = null;
            try {
                jar = new JarFile(jarSeg.getTemporaryFile());
                String entryName = null;
                entryName = loadReq.getStreamId() > 0 ? this.getTempFilePrefix() + loadReq.getFileId() + "_" + loadReq.getStreamId() + ".tmp" : this.getTempFilePrefix() + loadReq.getFileId() + ".tmp";
                JarEntry jarEntry = jar.getJarEntry(entryName);
                if (jarEntry != null) {
                    jarIn = jar.getInputStream(jarEntry);
                    outFile = new FileOutputStream(tempFile);
                    long startTime = System.currentTimeMillis();
                    byte[] buf = new byte[1024];
                    int totLen = 0;
                    int rdlen = jarIn.read(buf);
                    while (rdlen > 0) {
                        outFile.write(buf, 0, rdlen);
                        totLen += rdlen;
                        rdlen = jarIn.read(buf);
                    }
                    long stopTime = System.currentTimeMillis();
                    if (this.hasDebug()) {
                        Debug.println("Loaded file " + jarEntry.getName() + ", size=" + totLen + ", in " + (stopTime - startTime) + "ms");
                    }
                    jarIn.close();
                    jarIn = null;
                    outFile.close();
                    outFile = null;
                } else {
                    if (this.hasDebug()) {
                        Debug.println("## DBFileLoader Failed to find file in Jar, fid=" + loadReq.getFileId() + ", jar=" + jarSeg.getTemporaryFile());
                    }
                    loadSts = 2;
                }
            }
            catch (Exception ex) {
                Debug.println("Error in worker thread=" + loadReq.getThreadId());
                Debug.println(ex);
            }
            finally {
                if (jarIn != null) {
                    try {
                        jarIn.close();
                    }
                    catch (IOException ex) {}
                }
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException ex) {}
                }
                if (outFile != null) {
                    try {
                        outFile.close();
                    }
                    catch (IOException ex) {
                        Debug.println(ex);
                    }
                }
            }
        }
        return loadSts;
    }

    @Override
    public int storeFile(FileRequest req) throws Exception {
        int saveSts = 2;
        if (req instanceof SingleFileRequest) {
            SingleFileRequest singleReq = (SingleFileRequest)req;
            saveSts = this.storeSingleFile(singleReq);
            if (saveSts == 0 || saveSts == 2) {
                this.m_stateCache.setDataUpdateCompleted(singleReq.getFileState());
            }
        } else if (req instanceof MultipleFileRequest) {
            MultipleFileRequest multiReq = (MultipleFileRequest)req;
            saveSts = this.storeMultipleFile(multiReq);
            if (saveSts == 0 || saveSts == 2) {
                for (int idx = 0; idx < multiReq.getNumberOfFiles(); ++idx) {
                    CachedFileInfo cacheFileInfo = multiReq.getFileInfo(idx);
                    if (cacheFileInfo == null || !cacheFileInfo.hasFileState()) continue;
                    this.m_stateCache.setDataUpdateCompleted(cacheFileInfo.getFileState());
                }
            }
        } else {
            Debug.println("## DBFileLoader Unknown save type - " + req.getClass().getName());
        }
        return saveSts;
    }

    protected final int storeSingleFile(SingleFileRequest saveReq) throws Exception {
        long startTime = 0L;
        if (this.hasDebug()) {
            Debug.println("## DBFileLoader storeFile() req=" + saveReq.toString() + ", thread=" + Thread.currentThread().getName());
            startTime = System.currentTimeMillis();
        }
        File tempFile = new File(saveReq.getTemporaryFile());
        FileSegment fileSeg = this.findFileSegmentForPath(saveReq.getVirtualPath());
        if (!tempFile.exists() || fileSeg == null) {
            if (this.hasDebug()) {
                Debug.println("  Temporary file deleted");
            }
            return 2;
        }
        this.runFileStoreProcessors(this.m_dbCtx, saveReq.getFileState(), fileSeg);
        long fileSize = tempFile.length();
        if (this.hasDebug()) {
            Debug.println("## DBFileLoader fileSize=" + fileSize);
        }
        fileSeg.setStatus(5);
        fileSeg.getInfo().setUpdated(false);
        try {
            this.getDBDataInterface().saveFileData(saveReq.getFileId(), saveReq.getStreamId(), fileSeg);
        }
        catch (DBException ex) {
            Debug.println(ex);
        }
        catch (IOException ex) {
            Debug.println(ex);
        }
        if (this.hasDebug()) {
            long endTime = System.currentTimeMillis();
            Debug.println("## DBFileLoader saved file=" + saveReq.toString() + ", time=" + (endTime - startTime) + "ms");
        }
        fileSeg.setStatus(6, false);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int storeMultipleFile(MultipleFileRequest saveReq) throws Exception {
        CachedFileInfo finfo;
        int i;
        File jarFile = null;
        ZipOutputStream outJar = null;
        try {
            jarFile = File.createTempFile("JAR_", ".jar", this.getCurrentTempDirectory());
            FileOutputStream outFile = new FileOutputStream(jarFile);
            outJar = new JarOutputStream(outFile);
            outJar.setLevel(this.getJarCompressionLevel());
            byte[] inbuf = new byte[65000];
            for (i = 0; i < saveReq.getNumberOfFiles(); ++i) {
                finfo = saveReq.getFileInfo(i);
                FileState fstate = finfo.getFileState();
                if (this.hasDebug()) {
                    Debug.println("DBFileLoader storeMultipleFile() info=" + finfo + ", fstate=" + fstate);
                }
                if (fstate != null && fstate.fileExists()) {
                    String entryName = null;
                    entryName = finfo.getStreamId() > 0 ? this.getTempFilePrefix() + finfo.getFileId() + "_" + finfo.getStreamId() + ".tmp" : this.getTempFilePrefix() + finfo.getFileId() + ".tmp";
                    FileInputStream tempFile = null;
                    try {
                        tempFile = new FileInputStream(finfo.getTemporaryPath());
                        JarEntry jarEntry = new JarEntry(entryName);
                        ((JarOutputStream)outJar).putNextEntry(jarEntry);
                        int rdlen = tempFile.read(inbuf);
                        while (rdlen > 0) {
                            outJar.write(inbuf, 0, rdlen);
                            rdlen = tempFile.read(inbuf);
                        }
                        tempFile.close();
                        outJar.closeEntry();
                    }
                    catch (Exception ex) {
                        if (!this.hasDebug()) continue;
                        Debug.println("Failed to store " + finfo.getTemporaryPath());
                        Debug.println(ex);
                    }
                    continue;
                }
                if (!this.hasDebug()) continue;
                Debug.println("## DBFileLoader storeMultipleFile() ignored file " + finfo.getTemporaryPath() + ", exists=false");
            }
        }
        catch (IOException ex) {
            Debug.println(ex);
        }
        finally {
            if (outJar != null) {
                try {
                    outJar.close();
                }
                catch (Exception ex) {}
            }
        }
        int saveSts = 1;
        try {
            DBDataDetailsList fileList = new DBDataDetailsList();
            for (i = 0; i < saveReq.getNumberOfFiles(); ++i) {
                finfo = saveReq.getFileInfo(i);
                fileList.addFile(new DBDataDetails(finfo.getFileId(), finfo.getStreamId()));
            }
            this.getDBDataInterface().saveJarData(jarFile.getAbsolutePath(), fileList);
            saveSts = 0;
            if (!this.hasKeepJars()) {
                jarFile.delete();
            }
            for (i = 0; i < saveReq.getNumberOfFiles(); ++i) {
                FileSegmentInfo fileSegInfo;
                finfo = saveReq.getFileInfo(i);
                if (!finfo.hasFileState() || (fileSegInfo = (FileSegmentInfo)finfo.getFileState().findAttribute(DBFileSegmentInfo)) == null) continue;
                fileSegInfo.setQueued(false);
                fileSegInfo.setUpdated(false);
                fileSegInfo.setStatus(6);
            }
        }
        catch (DBException ex) {
            Debug.println(ex);
        }
        catch (IOException ex) {
            Debug.println(ex);
        }
        return saveSts;
    }

    @Override
    public void initializeLoader(ConfigElement params, DeviceContext ctx) throws FileLoaderException, IOException {
        ConfigElement nv;
        ConfigElement fileProcs;
        ConfigElement nameVal;
        block56: {
            if (params.getChild("Debug") != null) {
                this.m_debug = true;
            }
            if ((nameVal = params.getChild("ThreadPoolSize")) != null && (nameVal.getValue() == null || nameVal.getValue().length() == 0)) {
                throw new FileLoaderException("FileLoader ThreadPoolSize parameter is null");
            }
            this.m_readWorkers = 4;
            this.m_writeWorkers = 4;
            if (nameVal != null) {
                try {
                    String numVal = nameVal.getValue();
                    int rdCnt = -1;
                    int wrtCnt = -1;
                    int pos = numVal.indexOf(58);
                    if (pos == -1) {
                        wrtCnt = rdCnt = Integer.parseInt(numVal);
                    } else {
                        String val = numVal.substring(0, pos);
                        rdCnt = Integer.parseInt(val);
                        val = numVal.substring(pos + 1);
                        wrtCnt = Integer.parseInt(val);
                    }
                    this.m_readWorkers = rdCnt;
                    this.m_writeWorkers = wrtCnt;
                }
                catch (NumberFormatException ex) {
                    throw new FileLoaderException("DBFileLoader Invalid ThreadPoolSize value, " + ex.toString());
                }
            }
            if (this.m_readWorkers < 1 || this.m_readWorkers > 50) {
                throw new FileLoaderException("DBFileLoader Invalid ThreadPoolSize (read), valid range is 1-50");
            }
            if (this.m_writeWorkers < 1 || this.m_writeWorkers > 50) {
                throw new FileLoaderException("DBFileLoader Invalid ThreadPoolSize (write), valid range is 1-50");
            }
            ConfigElement tempArea = params.getChild("TempDirectory");
            if (tempArea == null || tempArea.getValue() == null || tempArea.getValue().length() == 0) {
                throw new FileLoaderException("FileLoader TempDirectory not specified or null");
            }
            this.m_tempDirName = tempArea.getValue();
            if (this.m_tempDirName != null && !this.m_tempDirName.endsWith(File.separator)) {
                this.m_tempDirName = this.m_tempDirName + File.separator;
            }
            this.m_tempDir = new File(this.m_tempDirName);
            if (!this.m_tempDir.exists() || !this.m_tempDir.isDirectory()) {
                throw new FileLoaderException("FileLoader TempDirectory does not exist, or is not a directory, " + this.m_tempDirName);
            }
            if (!this.m_tempDir.canWrite()) {
                throw new FileLoaderException("FileLoader TempDirectory is not writeable, " + this.m_tempDirName);
            }
            this.createNewTempDirectory();
            ConfigElement maxFiles = params.getChild("MaximumFilesPerDirectory");
            if (maxFiles != null) {
                try {
                    this.m_tempMax = Integer.parseInt(maxFiles.getValue());
                    if (this.m_tempMax < 10 || this.m_tempMax > 20000) {
                        throw new FileLoaderException("FileLoader MaximumFilesPerDirectory out of valid range (10-20000)");
                    }
                    break block56;
                }
                catch (NumberFormatException ex) {
                    throw new FileLoaderException("FileLoader MaximumFilesPerDirectory invalid, " + maxFiles.getValue());
                }
            }
            this.m_tempMax = 500;
        }
        if ((nameVal = params.getChild("SmallFileSize")) != null) {
            this.m_sizePerJar = 200000;
            this.m_filesPerJar = 25;
            try {
                this.m_smallFileSize = MemorySize.getByteValue(nameVal.getValue());
                if (this.m_smallFileSize < 0L) {
                    throw new FileLoaderException("Invalid small file size value, " + nameVal.getValue());
                }
            }
            catch (NumberFormatException ex) {
                throw new FileLoaderException("Invalid small file size value, " + nameVal.getValue());
            }
            nameVal = params.getChild("FilesPerJar");
            if (nameVal != null) {
                try {
                    this.m_filesPerJar = Integer.parseInt(nameVal.getValue());
                    if (this.m_filesPerJar < 5) {
                        throw new FileLoaderException("Files per jar setting is below minimum of 5");
                    }
                }
                catch (NumberFormatException ex) {
                    throw new FileLoaderException("Invalid files per Jar setting, " + nameVal.getValue());
                }
            }
            if ((nameVal = params.getChild("SizePerJar")) != null) {
                try {
                    this.m_sizePerJar = MemorySize.getByteValueInt(nameVal.getValue());
                    if (this.m_sizePerJar < 100000) {
                        throw new FileLoaderException("Size per jar setting is below minimum of 100000");
                    }
                }
                catch (NumberFormatException ex) {
                    throw new FileLoaderException("Invalid size per Jar setting, " + nameVal.getValue());
                }
            }
            this.m_tranTimeout = 5000L;
            nameVal = params.getChild("TransactionTimeout");
            if (nameVal != null) {
                try {
                    this.m_tranTimeout = Long.parseLong(nameVal.getValue()) * 1000L;
                    if (this.m_tranTimeout < 2000L || this.m_tranTimeout > 60000L) {
                        throw new FileLoaderException("Invalid transaction timeout value, out of valid range, " + nameVal.getValue());
                    }
                }
                catch (NumberFormatException ex) {
                    throw new FileLoaderException("Invalid transaction timeout value, " + nameVal.getValue());
                }
            }
        }
        if ((fileProcs = params.getChild("FileProcessors")) != null && fileProcs.hasChildren()) {
            List<ConfigElement> procList = fileProcs.getChildren();
            for (ConfigElement procElem : procList) {
                if (procElem.getValue() == null || procElem.getValue().length() == 0) {
                    throw new FileLoaderException("Empty file processor class name");
                }
                try {
                    Object procObj = Class.forName(procElem.getValue()).newInstance();
                    if (procObj instanceof FileProcessor) {
                        this.addFileProcessor((FileProcessor)procObj);
                        continue;
                    }
                    throw new FileLoaderException("Class " + procElem.getValue() + " is not a FileProcessor implementation");
                }
                catch (ClassNotFoundException ex) {
                    throw new FileLoaderException("File processor class not found, " + procElem.getValue());
                }
                catch (InstantiationException ex) {
                    throw new FileLoaderException("File processor exception, " + ex.toString());
                }
                catch (IllegalAccessException ex) {
                    throw new FileLoaderException("File processor exception, " + ex.toString());
                }
            }
        }
        if ((nv = params.getChild("FragmentSize")) != null) {
            this.m_fragSize = MemorySize.getByteValue(nv.getValue());
            if (this.m_fragSize < 65536L || this.m_fragSize > 0x40000000L) {
                throw new FileLoaderException("FragmentSize is out of valid range (64K - 20Mb");
            }
        }
        if ((nv = params.getChild("KeepJars")) != null) {
            this.m_keepJars = true;
        }
        this.m_jarCompressLevel = 0;
        nv = params.getChild("JarCompressionLevel");
        if (nv != null) {
            try {
                this.m_jarCompressLevel = Integer.parseInt(nv.getValue());
                if (this.m_jarCompressLevel < 0 || this.m_jarCompressLevel > 9) {
                    throw new FileLoaderException("Invalid Jar compression level, valid range is 0 - 9");
                }
            }
            catch (NumberFormatException ex) {
                throw new FileLoaderException("Invalid Jar compression level, " + nv.getValue());
            }
        }
        if (ctx instanceof DBDeviceContext) {
            this.m_dbCtx = (DBDeviceContext)ctx;
            if (!this.getContext().getDBInterface().supportsFeature(4)) {
                throw new FileLoaderException("DBLoader requires queue support in database interface");
            }
            if (!(this.getContext().getDBInterface() instanceof DBQueueInterface)) {
                throw new FileLoaderException("Database interface does not implement queue interface");
            }
            if (!this.getContext().getDBInterface().supportsFeature(8)) {
                throw new FileLoaderException("DBLoader requires data support in database interface");
            }
            if (!(this.getContext().getDBInterface() instanceof DBDataInterface)) {
                throw new FileLoaderException("Database interface does not implement data interface");
            }
            this.m_dbDataInterface = (DBDataInterface)((Object)this.getContext().getDBInterface());
            if (this.getSmallFileSize() > 0L && !this.getContext().getDBInterface().supportsFeature(16)) {
                throw new FileLoaderException("DBLoader requires Jar data support in database interface");
            }
        } else {
            throw new FileLoaderException("Requires database device context");
        }
        if (params.getChild("ThreadDebug") != null) {
            this.m_threadDebug = true;
        }
    }

    @Override
    public void startLoader(DeviceContext ctx) {
        DBQueueInterface dbQueue;
        block7: {
            this.m_stateCache = this.getContext().getStateCache();
            this.m_stateCache.addStateListener(this);
            dbQueue = null;
            if (!(this.getContext().getDBInterface() instanceof DBQueueInterface)) {
                throw new RuntimeException("Database interface does not implement queue interface");
            }
            dbQueue = (DBQueueInterface)((Object)this.getContext().getDBInterface());
            FileRequestQueue recoveredQueue = null;
            try {
                recoveredQueue = dbQueue.performQueueCleanup(this.m_tempDir, TempDirPrefix, TempFilePrefix, JarFilePrefix);
                if (recoveredQueue != null && this.hasDebug()) {
                    Debug.println("[DBLoader] Cleanup recovered " + recoveredQueue.numberOfRequests() + " pending save files");
                }
            }
            catch (DBException ex) {
                if (!this.hasDebug()) break block7;
                Debug.println(ex);
            }
        }
        FileRequestQueue saveQueue = new FileRequestQueue();
        try {
            dbQueue.loadFileRequests(1, 1, saveQueue, 1);
            dbQueue.loadFileRequests(1, 2, saveQueue, 1);
        }
        catch (DBException ex) {
            // empty catch block
        }
        this.m_backgroundLoader = new BackgroundLoadSave("DBLdr", dbQueue, this.m_stateCache, this);
        this.m_backgroundLoader.setReadWorkers(this.m_readWorkers);
        this.m_backgroundLoader.setWriteWorkers(this.m_writeWorkers);
        this.m_backgroundLoader.setDebug(this.m_threadDebug);
        this.m_backgroundLoader.startThreads(saveQueue.numberOfRequests());
        if (this.getSmallFileSize() > 0L) {
            this.m_backgroundLoader.enableTransactions();
            this.m_transTimer = new TransactionTimer("DBLdrTransTimer", this.getTransactionTimeout());
        }
    }

    @Override
    public void shutdownLoader(boolean immediate) {
        if (this.m_backgroundLoader != null) {
            this.m_backgroundLoader.shutdownThreads();
        }
        if (this.m_transTimer != null) {
            this.m_transTimer.shutdownRequest();
        }
    }

    protected final void runFileStoreProcessors(DiskDeviceContext context, FileState state, FileSegment segment) {
        block4: {
            if (this.m_fileProcessors == null || this.m_fileProcessors.numberOfProcessors() == 0) {
                return;
            }
            try {
                for (int i = 0; i < this.m_fileProcessors.numberOfProcessors(); ++i) {
                    FileProcessor fileProc = this.m_fileProcessors.getProcessorAt(i);
                    fileProc.processStoredFile(context, state, segment);
                }
                segment.closeFile();
            }
            catch (Exception ex) {
                if (!this.hasDebug()) break block4;
                Debug.println("$$ Store file processor exception");
                Debug.println(ex);
            }
        }
    }

    protected final void runFileLoadedProcessors(DiskDeviceContext context, FileState state, FileSegment segment) {
        block4: {
            if (this.m_fileProcessors == null || this.m_fileProcessors.numberOfProcessors() == 0) {
                return;
            }
            try {
                for (int i = 0; i < this.m_fileProcessors.numberOfProcessors(); ++i) {
                    FileProcessor fileProc = this.m_fileProcessors.getProcessorAt(i);
                    fileProc.processLoadedFile(context, state, segment);
                }
                segment.closeFile();
            }
            catch (Exception ex) {
                if (!this.hasDebug()) break block4;
                Debug.println("$$ Load file processor exception");
                Debug.println(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final FileState createFileStateForRequest(int fid, String tempPath, String virtPath, int sts) {
        FileState state = this.m_stateCache.findFileState(virtPath, false);
        if (state == null) {
            FileState fileState = state = this.m_stateCache.findFileState(virtPath, true);
            synchronized (fileState) {
                state.setExpiryTime(-1L);
                state.setFileStatus(1);
                state.setFileId(fid);
                FileSegmentInfo fileSegInfo = (FileSegmentInfo)state.findAttribute(DBFileSegmentInfo);
                FileSegment fileSeg = null;
                if (fileSegInfo == null) {
                    fileSegInfo = new FileSegmentInfo();
                    fileSegInfo.setTemporaryFile(tempPath);
                    fileSeg = new FileSegment(fileSegInfo, true);
                    fileSeg.setStatus(sts, true);
                    state.addAttribute(DBFileSegmentInfo, fileSegInfo);
                } else {
                    fileSeg = new FileSegment(fileSegInfo, true);
                    fileSeg.setStatus(sts, true);
                }
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final FileSegment findFileSegmentForPath(String virtPath) {
        FileState fstate = this.m_stateCache.findFileState(virtPath, false);
        if (fstate == null) {
            return null;
        }
        FileSegmentInfo segInfo = null;
        FileSegment fileSeg = null;
        FileState fileState = fstate;
        synchronized (fileState) {
            segInfo = (FileSegmentInfo)fstate.findAttribute(DBFileSegmentInfo);
            fileSeg = new FileSegment(segInfo, true);
        }
        return fileSeg;
    }

    @Override
    public boolean supportsStreams() {
        if (this.getContext() != null) {
            return this.getContext().getDBInterface().supportsFeature(1);
        }
        return true;
    }

    private final void createNewTempDirectory() {
        this.m_curTempName = this.m_tempDirName + this.getTempDirectoryPrefix() + this.m_curTempIdx++;
        this.m_curTempDir = new File(this.m_curTempName);
        if (!this.m_curTempDir.exists()) {
            this.m_curTempDir.mkdir();
        }
        this.m_tempCount = 0;
        if (this.hasDebug()) {
            Debug.println("DBFileLoader Created new temp directory - " + this.m_curTempName);
        }
    }

    @Override
    public boolean fileStateExpired(FileState state) {
        FileSegmentInfo segInfo = (FileSegmentInfo)state.findAttribute(DBFileSegmentInfo);
        boolean expire = true;
        if (segInfo != null) {
            if (!segInfo.isQueued()) {
                try {
                    if (segInfo.hasStatus() != 0) {
                        File tempFile;
                        File subDir;
                        String[] files;
                        try {
                            segInfo.deleteTemporaryFile();
                        }
                        catch (IOException ex) {
                            Debug.println("Delete temp file error: " + ex.toString());
                            File tempFile2 = new File(segInfo.getTemporaryFile());
                            Debug.println("  TempFile file=" + tempFile2.getAbsolutePath() + ", exists=" + tempFile2.exists());
                            Debug.println("  FileState state=" + state);
                            Debug.println("  FileSegmentInfo segInfo=" + segInfo);
                            Debug.println("  StateCache size=" + this.m_stateCache.numberOfStates());
                        }
                        state.removeAttribute(DBFileSegmentInfo);
                        segInfo.setStatus(0);
                        state.setDataStatus(0);
                        if (!(segInfo.getTemporaryFile().startsWith(this.m_curTempName) || (files = (subDir = (tempFile = new File(segInfo.getTemporaryFile())).getParentFile()).list()) != null && files.length != 0)) {
                            subDir.delete();
                        }
                        expire = false;
                        if (this.hasDebug()) {
                            Debug.println("$$ Deleted temporary file " + segInfo.getTemporaryFile() + " [EXPIRED] $$");
                        }
                    }
                    if (!expire) {
                        state.setExpiryTime(System.currentTimeMillis() + this.m_stateCache.getFileStateExpireInterval());
                    }
                }
                catch (Exception ex) {
                    Debug.println("$$  " + ex.toString());
                    Debug.println("  state=" + state);
                }
            } else {
                expire = false;
            }
        } else if (state.isDirectory()) {
            expire = true;
        }
        return expire;
    }

    @Override
    public void fileStateClosed(FileState state) {
        if (state == null) {
            Debug.println("%%%%% FileLoader.fileStateClosed() state=NULL %%%%%");
            return;
        }
        FileSegmentInfo segInfo = (FileSegmentInfo)state.findAttribute(DBFileSegmentInfo);
        if (segInfo != null && !segInfo.isQueued() && segInfo.hasStatus() != 4) {
            try {
                segInfo.deleteTemporaryFile();
                if (this.hasDebug()) {
                    Debug.println("$$ Deleted temporary file " + segInfo.getTemporaryFile() + " [CLOSED] $$");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CachedNetworkFile createNetworkFile(FileState state, FileOpenParams params, String fname, int fid, int stid, int did) throws IOException {
        FileSegment fileSeg = null;
        CachedNetworkFile netFile = null;
        FileState fileState = state;
        synchronized (fileState) {
            FileSegmentInfo fileSegInfo = (FileSegmentInfo)state.findAttribute(DBFileSegmentInfo);
            if (fileSegInfo == null) {
                if (this.m_tempCount++ >= this.m_tempMax) {
                    this.createNewTempDirectory();
                }
                StringBuffer tempName = new StringBuffer();
                tempName.append(this.getTempFilePrefix());
                tempName.append(fid);
                if (stid > 0) {
                    tempName.append("_");
                    tempName.append(stid);
                    Debug.println("## Temp file for stream ##");
                }
                tempName.append(".tmp");
                fileSegInfo = new FileSegmentInfo();
                fileSeg = FileSegment.createSegment(fileSegInfo, tempName.toString(), this.m_curTempDir, !params.isReadOnlyAccess());
                state.addAttribute(DBFileSegmentInfo, fileSegInfo);
                DBFileInfo finfo = (DBFileInfo)state.findAttribute("FileInfo");
                if (finfo != null && finfo.getSize() == 0L) {
                    fileSeg.setStatus(3);
                }
            } else {
                fileSeg = new FileSegment(fileSegInfo, !params.isReadOnlyAccess());
                File tempFile = new File(fileSeg.getTemporaryFile());
                if (!tempFile.exists()) {
                    tempFile.createNewFile();
                    fileSeg.setStatus(0);
                }
            }
            FileStateProxy stateProxy = this.m_stateCache.getFileStateProxy(state);
            netFile = new CachedNetworkFile(fname, fid, stid, did, stateProxy, fileSeg, this);
            netFile.setGrantedAccess(params.isReadOnlyAccess() ? 1 : 3);
            netFile.setSequentialOnly(params.isSequentialAccessOnly());
            netFile.setAttributes(params.getAttributes());
            netFile.setFullName(params.getPath());
            if (stid != 0) {
                netFile.setStreamName(params.getStreamName());
            }
        }
        return netFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createTransactionRequest(SingleFileRequest req, NetworkFile netFile) {
        Object object = this.m_tranLock;
        synchronized (object) {
            ++this.m_totFiles;
            int fsize = netFile.getFileSizeInt();
            if (fsize < 1024) {
                fsize = 1024;
            }
            this.m_totFileSize += fsize;
            boolean lastFile = false;
            if (this.getFilesPerJar() > 0 && this.m_totFiles > this.getFilesPerJar()) {
                lastFile = true;
            } else if (this.getJarFileSize() > 0 && this.m_totFileSize >= this.getJarFileSize()) {
                lastFile = true;
            }
            req.setTransactionId(this.m_tranId, lastFile);
            this.m_lastTranFile = System.currentTimeMillis();
            if (lastFile) {
                ++this.m_tranId;
                this.m_totFiles = 0;
                this.m_totFileSize = 0;
                this.m_lastTranFile = 0L;
            }
        }
    }

    @Override
    public final void setContext(DBDeviceContext dbCtx) {
        this.m_dbCtx = dbCtx;
    }

    protected class TransactionTimer
    implements Runnable {
        private Thread m_thread;
        private long m_timeout;
        private long m_wakeup;
        private boolean m_shutdown = false;

        public TransactionTimer(String name, long timeout) {
            this.m_timeout = timeout;
            this.m_wakeup = timeout / 2L;
            this.m_thread = new Thread(this);
            this.m_thread.setName(name);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }

        public final void shutdownRequest() {
            this.m_shutdown = true;
            try {
                this.m_thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.m_shutdown) {
                try {
                    Thread.sleep(this.m_wakeup);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (this.m_shutdown) break;
                if (DBFileLoader.this.m_lastTranFile == 0L) continue;
                long timeNow = System.currentTimeMillis();
                Object object = DBFileLoader.this.m_tranLock;
                synchronized (object) {
                    if (DBFileLoader.this.m_lastTranFile + this.m_timeout < timeNow) {
                        DBFileLoader.this.m_backgroundLoader.flushTransaction(DBFileLoader.this.m_tranId);
                        DBFileLoader.this.m_tranId++;
                        DBFileLoader.this.m_totFiles = 0;
                        DBFileLoader.this.m_totFileSize = 0;
                        DBFileLoader.this.m_lastTranFile = 0L;
                        if (DBFileLoader.this.hasDebug()) {
                            Debug.println("BackgroundLoadSave Transaction timed out, queued for loading");
                        }
                    }
                }
            }
            if (DBFileLoader.this.hasDebug()) {
                Debug.println("BackgroundLoadSave Transaction timer shutdown");
            }
        }
    }
}

