/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.passthru;

import org.alfresco.jlan.server.auth.passthru.DomainMapping;
import org.alfresco.jlan.util.IPAddress;

public class SubnetDomainMapping
extends DomainMapping {
    private int m_subnet;
    private int m_mask;

    public SubnetDomainMapping(String domain, int subnet, int mask) {
        super(domain);
        this.m_subnet = subnet;
        this.m_mask = mask;
    }

    public final int getSubnet() {
        return this.m_subnet;
    }

    public final int getSubnetMask() {
        return this.m_mask;
    }

    @Override
    public boolean isMemberOfDomain(int clientIP) {
        return (clientIP & this.m_mask) == this.m_subnet;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getDomain());
        str.append(",");
        str.append(IPAddress.asString(this.getSubnet()));
        str.append(":");
        str.append(IPAddress.asString(this.getSubnetMask()));
        str.append("]");
        return str.toString();
    }
}

