/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.kerberos;

import java.io.IOException;
import java.util.Iterator;
import org.alfresco.jlan.server.auth.asn.DERBuffer;
import org.alfresco.jlan.server.auth.asn.DERGeneralString;
import org.alfresco.jlan.server.auth.asn.DERGeneralizedTime;
import org.alfresco.jlan.server.auth.asn.DERInteger;
import org.alfresco.jlan.server.auth.asn.DERObject;
import org.alfresco.jlan.server.auth.asn.DEROctetString;
import org.alfresco.jlan.server.auth.asn.DERSequence;
import org.alfresco.jlan.server.auth.kerberos.PrincipalName;
import org.alfresco.jlan.util.HexDump;

public class KrbAuthenticator {
    private String m_realm;
    private PrincipalName m_principalName;
    private long m_microseconds;
    private String m_timestamp;
    private int m_subKeyType;
    private byte[] m_subKey;
    private int m_seqNo;

    public KrbAuthenticator() {
    }

    public KrbAuthenticator(byte[] blob) throws IOException {
        this.parseAuthenticator(blob);
    }

    public final String getRealm() {
        return this.m_realm;
    }

    public final PrincipalName getPrincipalName() {
        return this.m_principalName;
    }

    public final String getTimestamp() {
        return this.m_timestamp;
    }

    public final int getSubKeyType() {
        return this.m_subKeyType;
    }

    public final byte[] getSubKey() {
        return this.m_subKey;
    }

    public final int getSequenceNumber() {
        return this.m_seqNo;
    }

    public final void parseAuthenticator(byte[] auth) throws IOException {
        DERBuffer derBuf = new DERBuffer(auth);
        DERObject derObj = derBuf.unpackObject();
        if (derObj instanceof DERSequence) {
            DERSequence derSeq = (DERSequence)derObj;
            Iterator<DERObject> iterObj = derSeq.getObjects();
            block14: while (iterObj.hasNext()) {
                derObj = iterObj.next();
                if (derObj == null || !derObj.isTagged()) continue;
                switch (derObj.getTagNo()) {
                    case 0: {
                        if (!(derObj instanceof DERInteger)) break;
                        DERInteger derInt = (DERInteger)derObj;
                        if (derInt.intValue() == 5) continue block14;
                        throw new IOException("");
                    }
                    case 1: {
                        if (!(derObj instanceof DERGeneralString)) break;
                        DERGeneralString derStr = (DERGeneralString)derObj;
                        this.m_realm = derStr.getValue();
                        break;
                    }
                    case 2: {
                        if (!(derObj instanceof DERSequence)) break;
                        DERSequence derPrincSeq = (DERSequence)derObj;
                        this.m_principalName = new PrincipalName();
                        this.m_principalName.parsePrincipalName(derPrincSeq);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        if (!(derObj instanceof DERInteger)) break;
                        DERInteger derInt = (DERInteger)derObj;
                        this.m_microseconds = derInt.intValue();
                        break;
                    }
                    case 5: {
                        if (!(derObj instanceof DERGeneralizedTime)) break;
                        DERGeneralizedTime derTime = (DERGeneralizedTime)derObj;
                        this.m_timestamp = derTime.getValue();
                        break;
                    }
                    case 6: {
                        if (!(derObj instanceof DERSequence)) break;
                        DERSequence derEncSeq = (DERSequence)derObj;
                        Iterator<DERObject> iterSeq = derEncSeq.getObjects();
                        while (iterSeq.hasNext()) {
                            derObj = iterSeq.next();
                            if (derObj == null || !derObj.isTagged()) continue;
                            switch (derObj.getTagNo()) {
                                case 0: {
                                    if (!(derObj instanceof DERInteger)) break;
                                    DERInteger derInt = (DERInteger)derObj;
                                    this.m_subKeyType = derInt.intValue();
                                    break;
                                }
                                case 1: {
                                    if (!(derObj instanceof DEROctetString)) break;
                                    DEROctetString derOct = (DEROctetString)derObj;
                                    this.m_subKey = derOct.getValue();
                                }
                            }
                        }
                        continue block14;
                    }
                    case 7: {
                        if (!(derObj instanceof DERInteger)) break;
                        DERInteger derInt = (DERInteger)derObj;
                        this.m_seqNo = derInt.intValue();
                        break;
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[KrbAuth Realm=");
        str.append(this.getRealm());
        str.append(",Principal=");
        str.append(this.getPrincipalName());
        str.append(",uSec=");
        str.append(this.m_microseconds);
        str.append(",Time=");
        str.append(this.getTimestamp());
        str.append(",SubKey=Type=");
        str.append(this.getSubKeyType());
        str.append(",Key=");
        str.append(HexDump.hexString(this.getSubKey()));
        str.append(",SeqNo=");
        str.append(this.getSequenceNumber());
        str.append("]");
        return str.toString();
    }
}

