/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.oncrpc.PortMapping;
import org.alfresco.jlan.oncrpc.RpcPacket;
import org.alfresco.jlan.oncrpc.RpcProcessor;
import org.alfresco.jlan.oncrpc.TcpRpcClient;
import org.alfresco.jlan.oncrpc.nfs.NFSConfigSection;
import org.alfresco.jlan.server.NetworkServer;
import org.alfresco.jlan.server.config.ServerConfiguration;

public abstract class RpcNetworkServer
extends NetworkServer
implements RpcProcessor {
    private static final Object _rpcRegisterLock = new Object();
    private int m_portMapperPort = 111;
    private int m_rpcRegisterPort;

    public RpcNetworkServer(String name, ServerConfiguration config) {
        super(name, config);
        NFSConfigSection nfsConfig = (NFSConfigSection)config.getConfigSection("NFS");
        if (nfsConfig != null) {
            this.m_rpcRegisterPort = nfsConfig.getRPCRegistrationPort();
        }
    }

    protected final void registerRPCServer(PortMapping mapping) throws IOException {
        PortMapping[] mappings = new PortMapping[]{mapping};
        this.registerRPCServer(mappings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void registerRPCServer(PortMapping[] mappings) throws IOException {
        if (this.m_portMapperPort == -1) {
            return;
        }
        InetAddress localHost = InetAddress.getByName("127.0.0.1");
        TcpRpcClient rpcClient = null;
        try {
            Object object = _rpcRegisterLock;
            synchronized (object) {
                rpcClient = new TcpRpcClient(localHost, this.m_portMapperPort, localHost, this.m_rpcRegisterPort, 512);
                RpcPacket setPortRpc = new RpcPacket(512);
                RpcPacket rxRpc = new RpcPacket(512);
                for (int i = 0; i < mappings.length; ++i) {
                    setPortRpc.buildRequestHeader(100000, 2, 1, 0, null, 0, null);
                    setPortRpc.packPortMapping(mappings[i]);
                    setPortRpc.setLength();
                    if (this.hasDebug()) {
                        Debug.println("[" + this.getProtocolName() + "] Register server RPC " + mappings[i] + " ...");
                    }
                    if ((rxRpc = rpcClient.sendRPC(setPortRpc, rxRpc)) != null && rxRpc.getAcceptStatus() == 0) {
                        if (!this.hasDebug()) continue;
                        Debug.println("[" + this.getProtocolName() + "] Registered successfully, " + mappings[i]);
                        continue;
                    }
                    Debug.println("[" + this.getProtocolName() + "] RPC Server registration failed for " + mappings[i]);
                    Debug.println("  Response:" + rxRpc);
                }
                rpcClient.closeConnection();
                rpcClient = null;
            }
        }
        catch (Exception ex) {
            if (this.hasDebug()) {
                Debug.println("[" + this.getProtocolName() + "] Failed to register RPC service");
                Debug.println(ex);
            }
        }
        finally {
            if (rpcClient != null) {
                rpcClient.closeConnection();
            }
        }
    }

    protected final void unregisterRPCServer(PortMapping mapping) throws IOException {
        PortMapping[] mappings = new PortMapping[]{mapping};
        this.unregisterRPCServer(mappings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void unregisterRPCServer(PortMapping[] mappings) throws IOException {
        if (this.m_portMapperPort == -1) {
            return;
        }
        InetAddress localHost = InetAddress.getByName("127.0.0.1");
        TcpRpcClient rpcClient = null;
        try {
            Object object = _rpcRegisterLock;
            synchronized (object) {
                rpcClient = new TcpRpcClient(localHost, this.m_portMapperPort, localHost, this.m_rpcRegisterPort, 512);
                RpcPacket setPortRpc = new RpcPacket(512);
                RpcPacket rxRpc = new RpcPacket(512);
                for (int i = 0; i < mappings.length; ++i) {
                    setPortRpc.buildRequestHeader(100000, 2, 2, 0, null, 0, null);
                    setPortRpc.packPortMapping(mappings[i]);
                    setPortRpc.setLength();
                    if (this.hasDebug()) {
                        Debug.println("[" + this.getProtocolName() + "] UnRegister server RPC " + mappings[i] + " ...");
                    }
                    if ((rxRpc = rpcClient.sendRPC(setPortRpc, rxRpc)) != null && rxRpc.getAcceptStatus() == 0) {
                        if (!this.hasDebug()) continue;
                        Debug.println("[" + this.getProtocolName() + "] UnRegistered successfully, " + mappings[i]);
                        continue;
                    }
                    Debug.println("[" + this.getProtocolName() + "] RPC Server unregistration failed for " + mappings[i]);
                    Debug.println("  Response:" + rxRpc);
                }
                rpcClient.closeConnection();
                rpcClient = null;
            }
        }
        catch (Exception ex) {
            if (this.hasDebug()) {
                Debug.println("[" + this.getProtocolName() + "] Failed to unregister RPC service");
                Debug.println(ex);
            }
        }
        finally {
            if (rpcClient != null) {
                rpcClient.closeConnection();
            }
        }
    }

    public final void setPortMapper(int port) {
        this.m_portMapperPort = port;
    }

    @Override
    public abstract void startServer();

    @Override
    public abstract void shutdownServer(boolean var1);

    @Override
    public abstract RpcPacket processRpc(RpcPacket var1) throws IOException;
}

