/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.app;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.alfresco.jlan.app.XMLServerConfiguration;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.debug.DebugConfigSection;
import org.alfresco.jlan.netbios.server.NetBIOSNameServer;
import org.alfresco.jlan.netbios.win32.Win32NetBIOS;
import org.alfresco.jlan.oncrpc.nfs.NFSConfigSection;
import org.alfresco.jlan.server.NetworkServer;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.smb.server.CIFSConfigSection;
import org.alfresco.jlan.smb.server.SMBServer;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;

public class JLANServerService
implements WrapperListener,
Runnable {
    private static final String DEFAULT_CONFIGFILENAME = "jlanserver.xml";
    private boolean m_shutdown;
    private ServerConfiguration m_config;
    private Thread m_serverThread;

    public Integer start(String[] args) {
        PrintStream out = System.out;
        String fileName = null;
        fileName = args.length < 1 ? System.getProperty("user.home") + File.separator + DEFAULT_CONFIGFILENAME : args[0];
        this.m_config = null;
        try {
            this.m_config = new XMLServerConfiguration();
            this.m_config.loadConfiguration(fileName);
        }
        catch (Exception ex) {
            out.println("%% Failed to load server configuration");
            ex.printStackTrace(out);
            return new Integer(2);
        }
        try {
            String localAddr = InetAddress.getLocalHost().getHostAddress();
            if (localAddr.equals("127.0.0.1")) {
                out.println("%% Local IP address resolves to 127.0.0.1, this may be caused by a mis-configured hosts file");
                return new Integer(3);
            }
        }
        catch (UnknownHostException ex) {
            out.println("%% Failed to get local IP address details");
            ex.printStackTrace(out);
            return new Integer(4);
        }
        try {
            if (this.m_config.hasConfigSection("CIFS")) {
                CIFSConfigSection cifsConfig = (CIFSConfigSection)this.m_config.getConfigSection("CIFS");
                if (cifsConfig.hasWin32NetBIOS()) {
                    Win32NetBIOS.LanaEnumerate();
                }
                if (cifsConfig.hasNetBIOSSMB()) {
                    this.m_config.addServer(JLANServerService.createNetBIOSServer(this.m_config));
                }
                this.m_config.addServer(JLANServerService.createSMBServer(this.m_config));
            }
            if (this.m_config.hasConfigSection("FTP")) {
                this.m_config.addServer(JLANServerService.createFTPServer(this.m_config));
            }
            if (this.m_config.hasConfigSection("NFS")) {
                NFSConfigSection nfsConfig = (NFSConfigSection)this.m_config.getConfigSection("NFS");
                if (nfsConfig.hasNFSPortMapper()) {
                    this.m_config.addServer(JLANServerService.createNFSPortMapper(this.m_config));
                }
                this.m_config.addServer(JLANServerService.createNFSMountServer(this.m_config));
                this.m_config.addServer(JLANServerService.createNFSServer(this.m_config));
            }
            this.m_serverThread = new Thread(this);
            this.m_serverThread.start();
        }
        catch (Exception ex) {
            out.println("%% Server error");
            ex.printStackTrace(out);
            return new Integer(5);
        }
        return null;
    }

    public int stop(int exitCode) {
        this.m_shutdown = true;
        DebugConfigSection dbgConfig = (DebugConfigSection)this.m_config.getConfigSection("Debug");
        if (this.m_config.numberOfServers() > 0) {
            for (int i = 0; i < this.m_config.numberOfServers(); ++i) {
                WrapperManager.signalStopping((int)5000);
                NetworkServer server = this.m_config.getServer(i);
                if (dbgConfig != null && dbgConfig.hasDebug()) {
                    Debug.println("Shutting server " + server.getProtocolName() + " ...");
                }
                this.m_config.getServer(i).shutdownServer(false);
            }
        }
        WrapperManager.signalStopped((int)5000);
        return exitCode;
    }

    public void controlEvent(int event) {
        if (!(WrapperManager.isControlledByNativeWrapper() || event != 200 && event != 201 && event != 203)) {
            WrapperManager.stop((int)0);
        }
    }

    public static void main(String[] args) {
        WrapperManager.start((WrapperListener)new JLANServerService(), (String[])args);
    }

    protected static final NetworkServer createSMBServer(ServerConfiguration config) throws Exception {
        return new SMBServer(config);
    }

    protected static final NetworkServer createNetBIOSServer(ServerConfiguration config) throws Exception {
        return new NetBIOSNameServer(config);
    }

    protected static final NetworkServer createFTPServer(ServerConfiguration config) throws Exception {
        return JLANServerService.createServer("org.alfresco.jlan.ftp.FTPServer", config);
    }

    protected static final NetworkServer createNFSServer(ServerConfiguration config) throws Exception {
        return JLANServerService.createServer("org.alfresco.jlan.oncrpc.nfs.NFSServer", config);
    }

    protected static final NetworkServer createNFSMountServer(ServerConfiguration config) throws Exception {
        return JLANServerService.createServer("org.alfresco.jlan.oncrpc.mount.MountServer", config);
    }

    protected static final NetworkServer createNFSPortMapper(ServerConfiguration config) throws Exception {
        return JLANServerService.createServer("org.alfresco.jlan.oncprc.portmap.PortMapperServer", config);
    }

    protected static final NetworkServer createServer(String className, ServerConfiguration config) throws Exception {
        NetworkServer srv = null;
        Class[] classes = new Class[]{ServerConfiguration.class};
        Constructor<?> srvConstructor = Class.forName(className).getConstructor(classes);
        Object[] args = new Object[]{config};
        srv = (NetworkServer)srvConstructor.newInstance(args);
        return srv;
    }

    @Override
    public void run() {
        if (this.m_config.numberOfServers() > 0) {
            this.m_shutdown = false;
            DebugConfigSection dbgConfig = (DebugConfigSection)this.m_config.getConfigSection("Debug");
            for (int i = 0; i < this.m_config.numberOfServers(); ++i) {
                WrapperManager.signalStarting((int)10000);
                NetworkServer server = this.m_config.getServer(i);
                if (dbgConfig != null && dbgConfig.hasDebug()) {
                    Debug.println("Starting server " + server.getProtocolName() + " ...");
                }
                this.m_config.getServer(i).startServer();
            }
            while (!this.m_shutdown) {
                try {
                    Thread.sleep(250L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

