/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.math.opt;

import jdistlib.math.Constants;
import jdistlib.math.UnivariateFunction;

public class Optimization {
    public static final strictfp double optimize(UnivariateFunction f, double ax, double bx) {
        return Optimization.optimize(f, ax, bx, 1.0E-10, 1000);
    }

    public static final strictfp double optimize(UnivariateFunction f, double ax, double bx, double tol, int maxiter) {
        double x;
        block13: {
            double fx;
            double v;
            double a = ax;
            double b = bx;
            double w = v = a + 0.38196601125010515 * (b - a);
            x = v;
            double d = 0.0;
            double e = 0.0;
            int iterNo = 0;
            double fw = fx = f.eval(x);
            double fv = fx;
            double tol3 = tol / 3.0;
            do {
                double u;
                ++iterNo;
                double xm = (a + b) * 0.5;
                double tol1 = Constants.SQRT_DBL_EPSILON * Math.abs(x) + tol3;
                double t2 = tol1 * 2.0;
                if (Math.abs(x - xm) <= t2 - (b - a) * 0.5) break block13;
                double p = 0.0;
                double q = 0.0;
                double r = 0.0;
                if (Math.abs(e) > tol1) {
                    r = (x - w) * (fx - fv);
                    q = (x - v) * (fx - fw);
                    p = (x - v) * q - (x - w) * r;
                    if ((q = (q - r) * 2.0) > 0.0) {
                        p = -p;
                    } else {
                        q = -q;
                    }
                    r = e;
                    e = d;
                }
                if (Math.abs(p) >= Math.abs(q * 0.5 * r) || p <= q * (a - x) || p >= q * (b - x)) {
                    e = x < xm ? b - x : a - x;
                    d = 0.38196601125010515 * e;
                } else {
                    d = p / q;
                    u = x + d;
                    if (u - a < t2 || b - u < t2) {
                        double d2 = d = x >= xm ? -tol1 : tol1;
                    }
                }
                u = Math.abs(d) >= tol1 ? x + d : (d > 0.0 ? x + tol1 : x - tol1);
                double fu = f.eval(u);
                if (fu <= fx) {
                    if (u < x) {
                        b = x;
                    } else {
                        a = x;
                    }
                    v = w;
                    w = x;
                    x = u;
                    fv = fw;
                    fw = fx;
                    fx = fu;
                    continue;
                }
                if (u < x) {
                    a = u;
                } else {
                    b = u;
                }
                if (fu <= fw || w == x) {
                    v = w;
                    fv = fw;
                    w = u;
                    fw = fu;
                    continue;
                }
                if (!(fu <= fv) && v != x && v != w) continue;
                v = u;
                fv = fu;
            } while (iterNo < maxiter);
            System.err.println("Warning: Convergence failure in optimize function!");
        }
        return x;
    }

    public static final strictfp double zeroin(UnivariateFunction f, double ax, double bx, double tol, int maxiter) {
        double maxit = maxiter + 1;
        double a = ax;
        double b = bx;
        double c = a;
        double fa = f.eval(ax);
        double fb = f.eval(bx);
        double fc = fa;
        if (fa == 0.0) {
            return a;
        }
        if (fb == 0.0) {
            return b;
        }
        while (true) {
            double d = maxit;
            maxit = d - 1.0;
            if (!(d > 0.0)) break;
            double prev_step = b - a;
            if (Math.abs(fc) < Math.abs(fb)) {
                a = b;
                b = c;
                c = a;
                fa = fb;
                fb = fc;
                fc = fa;
            }
            double tol_act = 4.440892098500626E-16 * Math.abs(b) + tol / 2.0;
            double new_step = (c - b) / 2.0;
            if (Math.abs(new_step) <= tol_act || fb == 0.0) {
                return b;
            }
            if (Math.abs(prev_step) >= tol_act && Math.abs(fa) > Math.abs(fb)) {
                double q;
                double p;
                double t1;
                double cb = c - b;
                if (a == c) {
                    t1 = fb / fa;
                    p = cb * t1;
                    q = 1.0 - t1;
                } else {
                    q = fa / fc;
                    t1 = fb / fc;
                    double t2 = fb / fa;
                    p = t2 * (cb * q * (q - t1) - (b - a) * (t1 - 1.0));
                    q = (q - 1.0) * (t1 - 1.0) * (t2 - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                } else {
                    p = -p;
                }
                if (p < 0.75 * cb * q - Math.abs(tol_act * q) / 2.0 && p < Math.abs(prev_step * q / 2.0)) {
                    new_step = p / q;
                }
            }
            if (Math.abs(new_step) < tol_act) {
                new_step = new_step > 0.0 ? tol_act : -tol_act;
            }
            a = b;
            fa = fb;
            fb = f.eval(b += new_step);
            if (!(fb > 0.0 && fc > 0.0) && (!(fb < 0.0) || !(fc < 0.0))) continue;
            c = a;
            fc = fa;
        }
        System.err.println("Warning: Convergence failure in zeroin function!");
        return b;
    }

    public static void main(String[] args) {
        UnivariateFunction f = new UnivariateFunction(){

            public double eval(double x) {
                return (x -= 0.3333333333333333) * x;
            }

            public void setObjects(Object ... obj) {
            }

            public void setParameters(double ... params) {
            }
        };
        System.out.println(Optimization.optimize(f, 0.0, 1.0, 1.0E-4, 1000));
        System.out.println(Optimization.optimize(f, 0.0, 1.0, 0.0, 1000));
        f = new UnivariateFunction(){

            public double eval(double x) {
                return x * (x * x - 1.0) + 0.5;
            }

            public void setObjects(Object ... obj) {
            }

            public void setParameters(double ... params) {
            }
        };
        System.out.println(Optimization.zeroin(f, -2.0, 2.0, 1.0E-4, 1000));
        System.out.println(Optimization.zeroin(f, -2.0, 2.0, 1.0E-10, 1000));
        System.out.println(Optimization.zeroin(f, -2.0, 2.0, 0.0, 1000));
    }
}

