/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Beta;
import jdistlib.ChiSquare;
import jdistlib.Normal;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class T
extends GenericDistribution {
    protected double df;

    public static final double density(double x, double n, boolean give_log) {
        double u;
        double l_x2n;
        boolean lrg_x2n;
        if (Double.isNaN(x) || Double.isNaN(n)) {
            return x + n;
        }
        if (n <= 0.0) {
            return Double.NaN;
        }
        if (MathFunctions.isInfinite(x)) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (MathFunctions.isInfinite(n)) {
            return Normal.density(x, 0.0, 1.0, give_log);
        }
        double ax = Math.abs(x);
        double t = -MathFunctions.bd0(n / 2.0, (n + 1.0) / 2.0) + MathFunctions.stirlerr((n + 1.0) / 2.0) - MathFunctions.stirlerr(n / 2.0);
        double x2n = x * x / n;
        boolean bl = lrg_x2n = x2n > 4.503599627370496E15;
        if (lrg_x2n) {
            l_x2n = Math.log(ax) - Math.log(n) / 2.0;
            u = n * l_x2n;
        } else if (x2n > 0.2) {
            l_x2n = Math.log(1.0 + x2n) / 2.0;
            u = n * l_x2n;
        } else {
            l_x2n = Math.log1p(x2n) / 2.0;
            u = -MathFunctions.bd0(n / 2.0, (n + x * x) / 2.0) + x * x / 2.0;
        }
        if (give_log) {
            return t - u - (0.9189385332046728 + l_x2n);
        }
        double I_sqrt_ = lrg_x2n ? Math.sqrt(n) / ax : Math.exp(-l_x2n);
        return Math.exp(t - u) * 0.3989422804014327 * I_sqrt_;
    }

    public static final double cumulative(double x, double n, boolean lower_tail, boolean log_p) {
        double val;
        if (Double.isNaN(x) || Double.isNaN(n)) {
            return x + n;
        }
        if (n <= 0.0) {
            return Double.NaN;
        }
        if (MathFunctions.isInfinite(x)) {
            return x < 0.0 ? (lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0)) : (lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0));
        }
        if (MathFunctions.isInfinite(n)) {
            return Normal.cumulative(x, 0.0, 1.0, lower_tail, log_p);
        }
        double nx = 1.0 + x / n * x;
        if (nx > 1.0E100) {
            double lval = -0.5 * n * (2.0 * Math.log(Math.abs(x)) - Math.log(n)) - MathFunctions.lbeta(0.5 * n, 0.5) - Math.log(0.5 * n);
            val = log_p ? lval : Math.exp(lval);
        } else {
            double d = val = n > x * x ? Beta.cumulative(x * x / (n + x * x), 0.5, n / 2.0, false, log_p) : Beta.cumulative(1.0 / nx, n / 2.0, 0.5, true, log_p);
        }
        if (x <= 0.0) {
            boolean bl = lower_tail = !lower_tail;
        }
        if (log_p) {
            if (lower_tail) {
                return Math.log1p(-0.5 * Math.exp(val));
            }
            return val - 0.6931471805599453;
        }
        return lower_tail ? 0.5 - val + 0.5 : (val /= 2.0);
    }

    public static final double quantile(double p, double ndf, boolean lower_tail, boolean log_p) {
        double q;
        boolean is_neg_lower;
        double eps = 1.0E-12;
        if (Double.isNaN(p) || Double.isNaN(ndf)) {
            return p + ndf;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
        }
        if (ndf <= 0.0) {
            return Double.NaN;
        }
        if (ndf < 1.0) {
            double nx;
            double lx;
            double ux;
            double accu = 1.0E-13;
            double Eps = 1.0E-11;
            int iter = 0;
            double d = log_p ? (lower_tail ? Math.exp(p) : -Math.expm1(p)) : (p = lower_tail ? p : 0.5 - p + 0.5);
            if (p > 0.9999999999999998) {
                return Double.POSITIVE_INFINITY;
            }
            double pp = Math.min(0.9999999999999998, p * 1.00000000001);
            for (ux = 1.0; ux < Double.MAX_VALUE && T.cumulative(ux, ndf, true, false) < pp; ux *= 2.0) {
            }
            pp = p * 0.99999999999;
            for (lx = -1.0; lx > -1.7976931348623157E308 && T.cumulative(lx, ndf, true, false) > pp; lx *= 2.0) {
            }
            do {
                if (T.cumulative(nx = 0.5 * (lx + ux), ndf, true, false) > p) {
                    ux = nx;
                    continue;
                }
                lx = nx;
            } while ((ux - lx) / Math.abs(nx) > 1.0E-13 && ++iter < 1000);
            if (iter >= 1000) {
                return Double.NaN;
            }
            return 0.5 * (lx + ux);
        }
        if (ndf > 1.0E20) {
            return Normal.quantile(p, 0.0, 1.0, lower_tail, log_p);
        }
        double P = log_p ? Math.exp(p) : p;
        boolean neg = (!lower_tail || P < 0.5) && (lower_tail || P > 0.5);
        boolean bl = is_neg_lower = lower_tail == neg;
        P = neg ? 2.0 * (log_p ? (lower_tail ? P : -Math.expm1(p)) : (lower_tail ? p : 0.5 - p + 0.5)) : 2.0 * (log_p ? (lower_tail ? -Math.expm1(p) : P) : (lower_tail ? 0.5 - p + 0.5 : p));
        if (Math.abs(ndf - 2.0) < 1.0E-12) {
            q = P > Double.MIN_NORMAL ? (3.0 * P < 2.220446049250313E-16 ? 1.0 / Math.sqrt(P) : (P > 0.9 ? (1.0 - P) * Math.sqrt(2.0 / (P * (2.0 - P))) : Math.sqrt(2.0 / (P * (2.0 - P)) - 2.0))) : (log_p ? (is_neg_lower ? Math.exp(-p / 2.0) / 1.4142135623730951 : 1.0 / Math.sqrt(-Math.expm1(p))) : Double.POSITIVE_INFINITY);
        } else if (ndf < 1.000000000001) {
            q = P > 0.0 ? 1.0 / Math.tan(P * 1.5707963267948966) : (log_p ? (is_neg_lower ? 0.3183098861837907 * Math.exp(-p) : -1.0 / (Math.PI * Math.expm1(p))) : Double.POSITIVE_INFINITY);
        } else {
            boolean P_ok1;
            double x = 0.0;
            double y = 0.0;
            double log_P2 = 0.0;
            double a = 1.0 / (ndf - 0.5);
            double b = 48.0 / (a * a);
            double c = ((20700.0 * a / b - 98.0) * a - 16.0) * a + 96.36;
            double d = ((94.5 / (b + c) - 3.0) / b + 1.0) * Math.sqrt(a * 1.5707963267948966) * ndf;
            boolean P_ok = P_ok1 = P > Double.MIN_NORMAL || !log_p;
            if (P_ok1) {
                y = Math.pow(d * P, 2.0 / ndf);
                boolean bl2 = P_ok = y >= 2.220446049250313E-16;
            }
            if (!P_ok) {
                log_P2 = is_neg_lower ? (log_p ? p : Math.log(p)) : (log_p ? (p > -0.6931471805599453 ? Math.log(-Math.expm1(p)) : Math.log1p(-Math.exp(p))) : Math.log1p(-p));
                x = (Math.log(d) + 0.6931471805599453 + log_P2) / ndf;
                y = Math.exp(2.0 * x);
            }
            if (ndf < 2.1 && P > 0.5 || y > 0.05 + a) {
                x = P_ok ? Normal.quantile(0.5 * P, 0.0, 1.0, true, false) : Normal.quantile(log_P2, 0.0, 1.0, lower_tail, true);
                y = x * x;
                if (ndf < 5.0) {
                    c += 0.3 * (ndf - 4.5) * (x + 0.6);
                }
                c = (((0.05 * d * x - 5.0) * x - 7.0) * x - 2.0) * x + b + c;
                y = (((((0.4 * y + 6.3) * y + 36.0) * y + 94.5) / c - y - 3.0) / b + 1.0) * x;
                y = Math.expm1(a * y * y);
                q = Math.sqrt(ndf * y);
            } else if (!P_ok && x < -36.7368005696771) {
                q = Math.sqrt(ndf) * Math.exp(-x);
            } else {
                y = ((1.0 / (((ndf + 6.0) / (ndf * y) - 0.089 * d - 0.822) * (ndf + 2.0) * 3.0) + 0.5 / (ndf + 4.0)) * y - 1.0) * (ndf + 1.0) / (ndf + 2.0) + 1.0 / y;
                q = Math.sqrt(ndf * y);
            }
            if (P_ok1) {
                int it = 0;
                while (it++ < 10) {
                    double d2;
                    y = T.density(q, ndf, false);
                    if (!(d2 > 0.0) || !MathFunctions.isFinite(x = (T.cumulative(q, ndf, false, false) - P / 2.0) / y) || !(Math.abs(x) > 1.0E-14 * Math.abs(q))) break;
                    q += x * (1.0 + x * q * (ndf + 1.0) / (2.0 * (q * q + ndf)));
                }
            }
        }
        if (neg) {
            q = -q;
        }
        return q;
    }

    public static final double random(double df, RandomEngine random) {
        if (Double.isNaN(df) || df <= 0.0) {
            return Double.NaN;
        }
        if (MathFunctions.isInfinite(df)) {
            return Normal.random_standard(random);
        }
        double num = Normal.random_standard(random);
        return num / Math.sqrt(ChiSquare.random(df, random) / df);
    }

    public static final double[] random(int n, double df, RandomEngine random) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = T.random(df, random);
        }
        return rand;
    }

    public T(double df) {
        this.df = df;
    }

    public double density(double x, boolean log) {
        return T.density(x, this.df, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return T.cumulative(p, this.df, lower_tail, log_p);
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return T.quantile(q, this.df, lower_tail, log_p);
    }

    public double random() {
        return T.random(this.df, this.random);
    }
}

