/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class Exponential
extends GenericDistribution {
    protected double scale;

    public static final double density(double x, double scale, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(scale)) {
            return x + scale;
        }
        if (scale <= 0.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        return give_log ? -x / scale - Math.log(scale) : Math.exp(-x / scale) / scale;
    }

    public static final double cumulative(double x, double scale, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(scale)) {
            return x + scale;
        }
        if (scale < 0.0) {
            return Double.NaN;
        }
        if (x <= 0.0) {
            return log_p ? Double.NEGATIVE_INFINITY : 0.0;
        }
        x = -(x / scale);
        if (lower_tail) {
            return log_p ? (x > -0.6931471805599453 ? Math.log(-Math.expm1(x)) : Math.log1p(-Math.exp(x))) : -Math.expm1(x);
        }
        return log_p ? x : Math.exp(x);
    }

    public static final double quantile(double p, double scale, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(p) || Double.isNaN(scale)) {
            return p + scale;
        }
        if (scale < 0.0) {
            return Double.NaN;
        }
        if (log_p && p > 0.0 || !log_p && (p < 0.0 || p > 1.0)) {
            return Double.NaN;
        }
        if (p == (lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0))) {
            return 0.0;
        }
        return -scale * (lower_tail ? (log_p ? (p > -0.6931471805599453 ? Math.log(-Math.expm1(p)) : Math.log1p(-Math.exp(p))) : Math.log1p(-p)) : (log_p ? p : Math.log(p)));
    }

    public static final double random(double scale, RandomEngine random) {
        if (MathFunctions.isInfinite(scale) || scale <= 0.0) {
            if (scale == 0.0) {
                return 0.0;
            }
            return Double.NaN;
        }
        return scale * Exponential.random_standard(random);
    }

    public static final double random_standard(RandomEngine random) {
        double ustar;
        double[] q = new double[]{0.6931471805599453, 0.9333736875190459, 0.9888777961838675, 0.998495925291496, 0.9998292811061389, 0.9999833164100727, 0.9999985691438767, 0.9999998906925558, 0.9999999924734159, 0.9999999995283275, 0.9999999999728814, 0.9999999999985598, 0.999999999999929, 0.9999999999999968, 0.9999999999999999, 1.0};
        double a = 0.0;
        double u = random.nextDouble();
        while (u <= 0.0 || u >= 1.0) {
            u = random.nextDouble();
        }
        while (!((u += u) > 1.0)) {
            a += q[0];
        }
        u -= 1.0;
        if (u <= q[0]) {
            return a + u;
        }
        int i = 0;
        double umin = ustar = random.nextDouble();
        do {
            if (!(umin > (ustar = random.nextDouble()))) continue;
            umin = ustar;
        } while (u > q[++i]);
        return a + umin * q[0];
    }

    public static final double[] random(int n, double scale, RandomEngine random) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = Exponential.random(scale, random);
        }
        return rand;
    }

    public static final double[] random_standard(int n, RandomEngine random) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = Exponential.random_standard(random);
        }
        return rand;
    }

    public Exponential(double scale) {
        this.scale = scale;
    }

    public double density(double x, boolean log) {
        return Exponential.density(x, this.scale, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Exponential.cumulative(p, this.scale, lower_tail, log_p);
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Exponential.quantile(q, this.scale, lower_tail, log_p);
    }

    public double random() {
        return Exponential.random(this.scale, this.random);
    }
}

