/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class Zipf
extends GenericDistribution {
    protected int N;
    protected double s;

    public static final double density(int x, int N, double s, boolean give_log) {
        if (MathFunctions.isInfinite(s)) {
            return s;
        }
        if (N <= 0 || s <= 0.0) {
            return Double.NaN;
        }
        if (x <= 0 || x > N) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        return give_log ? -s * Math.log(x) - MathFunctions.lgharmonic(N, s) : Math.pow(x, -s) / MathFunctions.gharmonic(N, s);
    }

    public static final double cumulative(int x, int N, double s, boolean lower_tail, boolean log_p) {
        if (MathFunctions.isInfinite(s)) {
            return s;
        }
        if (N <= 0 || s <= 0.0) {
            return Double.NaN;
        }
        if (x <= 0) {
            return log_p ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (x >= N) {
            return log_p ? 0.0 : 1.0;
        }
        if (lower_tail) {
            return log_p ? MathFunctions.lgharmonic(x, s) - MathFunctions.lgharmonic(N, s) : MathFunctions.gharmonic(x, s) / MathFunctions.gharmonic(N, s);
        }
        double sum = 0.0;
        if (log_p) {
            for (int i = x + 1; i <= N; ++i) {
                sum = MathFunctions.logspace_add(sum, -s * Math.log(i));
            }
            return sum - MathFunctions.lgharmonic(N, s);
        }
        for (int i = x + 1; i <= N; ++i) {
            sum += Math.pow(i, -s);
        }
        return sum / MathFunctions.gharmonic(N, s);
    }

    public static final double quantile(double p, int N, double s, boolean lower_tail, boolean log_p) {
        int mid;
        double f_mid;
        if (MathFunctions.isInfinite(s)) {
            return s;
        }
        if (N <= 0 || s <= 0.0) {
            return Double.NaN;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? (double)N : 0.0;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? 0.0 : (double)N;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? 0.0 : (double)N;
            }
            if (p == 1.0) {
                return lower_tail ? (double)N : 0.0;
            }
        }
        int lo = 0;
        int hi = N;
        double f_lo = Zipf.cumulative(lo, N, s, lower_tail, log_p);
        double f_hi = Zipf.cumulative(hi, N, s, lower_tail, log_p);
        boolean pathological = false;
        do {
            if ((f_mid = Zipf.cumulative(mid = lo + hi, N, s, lower_tail, log_p)) == p && (f_hi == p || f_lo == p) && hi - lo > 2) {
                pathological = true;
            }
            if (lower_tail) {
                if (f_lo >= p) {
                    return lo;
                }
                if (f_mid > p) {
                    hi = mid;
                    f_hi = f_mid;
                    continue;
                }
                lo = mid;
                f_lo = f_mid;
                continue;
            }
            if (f_hi <= p) {
                return hi;
            }
            if (f_mid < p) {
                lo = mid;
                f_lo = f_mid;
                continue;
            }
            hi = mid;
            f_hi = f_mid;
        } while (hi - lo > 1);
        if (pathological) {
            System.err.println("Pathological case of Zipf.quantile! Quantile estimate may not be accurate!");
        }
        if (lower_tail) {
            return f_hi <= p ? (double)hi : (f_mid <= p ? (double)mid : (double)lo);
        }
        return f_lo >= p ? (double)lo : (f_mid >= p ? (double)mid : (double)hi);
    }

    public static final double random(int N, double s, RandomEngine random) {
        if (N <= 0 || s <= 0.0) {
            return Double.NaN;
        }
        double u1 = random.nextDouble();
        u1 = (double)((int)(1.34217728E8 * u1)) + random.nextDouble();
        u1 = Zipf.quantile(u1 / 1.34217728E8, N, s, true, false);
        return u1;
    }

    public static final double[] random(int n, int N, double s, RandomEngine random) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = Zipf.random(N, s, random);
        }
        return rand;
    }

    public Zipf(int N, double s) {
        this.N = N;
        this.s = s;
    }

    public double density(double x, boolean log) {
        return Zipf.density((int)x, this.N, this.s, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Zipf.cumulative((int)p, this.N, this.s, lower_tail, log_p);
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Zipf.quantile(q, this.N, this.s, lower_tail, log_p);
    }

    public double random() {
        return Zipf.random(this.N, this.s, this.random);
    }
}

