/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.evd;

import jdistlib.generic.GenericDistribution;
import jdistlib.rng.RandomEngine;

public class Rayleigh
extends GenericDistribution {
    protected double scale;

    public static final double density(double x, double scale, boolean log) {
        if (scale <= 0.0) {
            return Double.NaN;
        }
        double v = x / scale;
        x = Math.log(x) - 0.5 * v * v - 2.0 * Math.log(scale);
        return log ? x : Math.exp(x);
    }

    public static final double cumulative(double q, double scale, boolean lower_tail) {
        if (scale <= 0.0) {
            return Double.NaN;
        }
        if (q <= 0.0) {
            return 0.0;
        }
        q /= scale;
        q = -Math.expm1(-0.5 * q * q);
        return lower_tail ? q : 1.0 - q;
    }

    public static final double quantile(double p, double scale, boolean lower_tail) {
        if (scale <= 0.0 | p < 0.0 | p > 1.0) {
            return Double.NaN;
        }
        if (!lower_tail) {
            p = 1.0 - p;
        }
        return scale * Math.sqrt(-2.0 * Math.log1p(-p));
    }

    public static final double random(double scale, RandomEngine random) {
        return scale <= 0.0 ? Double.NaN : scale * Math.sqrt(-2.0 * Math.log(random.nextDouble()));
    }

    public static final double[] random(int n, double scale, RandomEngine random) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = Rayleigh.random(scale, random);
        }
        return rand;
    }

    public Rayleigh(double scale) {
        this.scale = scale;
    }

    public double density(double x, boolean log) {
        return Rayleigh.density(x, this.scale, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        p = Rayleigh.cumulative(p, this.scale, lower_tail);
        return log_p ? Math.log(p) : p;
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        if (log_p) {
            q = Math.exp(q);
        }
        return Rayleigh.quantile(q, this.scale, lower_tail);
    }

    public double random() {
        return Rayleigh.random(this.scale, this.random);
    }
}

