/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.math;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jdistlib.math.MathFunctions;
import jdistlib.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorMath {
    public static final double[] vpow(double x, double[] e) {
        double[] v = new double[e.length];
        for (int i = 0; i < e.length; ++i) {
            v[i] = Math.pow(x, e[i]);
        }
        return v;
    }

    public static final double[] vpow(double[] x, double e) {
        double[] v = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            v[i] = Math.pow(x[i], e);
        }
        return v;
    }

    public static final double[] vpow(double[] x, double[] e) {
        if (x.length != e.length) {
            throw new RuntimeException();
        }
        double[] v = new double[e.length];
        for (int i = 0; i < e.length; ++i) {
            v[i] = Math.pow(x[i], e[i]);
        }
        return v;
    }

    public static final double[] vpow(double x, int[] e) {
        double[] v = new double[e.length];
        for (int i = 0; i < e.length; ++i) {
            v[i] = Math.pow(x, e[i]);
        }
        return v;
    }

    public static final double[] vplus(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new RuntimeException();
        }
        double[] v = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            v[i] = a[i] + b[i];
        }
        return v;
    }

    public static final double[] vplus(double a, double[] b) {
        double[] v = new double[b.length];
        for (int i = 0; i < b.length; ++i) {
            v[i] = a + b[i];
        }
        return v;
    }

    public static final double[] vplus(double[] a, double b) {
        double[] v = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            v[i] = a[i] + b;
        }
        return v;
    }

    public static final double[] vmin(double[] e) {
        double[] v = new double[e.length];
        for (int i = 0; i < e.length; ++i) {
            v[i] = -e[i];
        }
        return v;
    }

    public static final double[] vmin(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new RuntimeException();
        }
        double[] v = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            v[i] = a[i] - b[i];
        }
        return v;
    }

    public static final double[] vmin(double[] a, double b) {
        double[] v = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            v[i] = a[i] - b;
        }
        return v;
    }

    public static final double[] vmin(double a, double[] b) {
        double[] v = new double[b.length];
        for (int i = 0; i < b.length; ++i) {
            v[i] = a - b[i];
        }
        return v;
    }

    public static final double[] vtimes(double a, double[] b) {
        double[] v = new double[b.length];
        for (int i = 0; i < b.length; ++i) {
            v[i] = a * b[i];
        }
        return v;
    }

    public static final double[] vtimes(double[] a, double b) {
        double[] v = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            v[i] = a[i] * b;
        }
        return v;
    }

    public static final double[] vtimes(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new RuntimeException();
        }
        double[] v = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            v[i] = a[i] * b[i];
        }
        return v;
    }

    public static final double[] vsq(double[] a) {
        double[] v = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            v[i] = a[i] * a[i];
        }
        return v;
    }

    public static final double[] vdiv(double[] a, double b) {
        double[] v = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            v[i] = a[i] / b;
        }
        return v;
    }

    public static final double[] vdiv(double a, double[] b) {
        double[] v = new double[b.length];
        for (int i = 0; i < b.length; ++i) {
            v[i] = a / b[i];
        }
        return v;
    }

    public static final double[] vdiv(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new RuntimeException();
        }
        double[] v = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            v[i] = a[i] / b[i];
        }
        return v;
    }

    public static final double[] vcomp(double[] e) {
        double[] v = new double[e.length];
        for (int i = 0; i < e.length; ++i) {
            v[i] = 1.0 - e[i];
        }
        return v;
    }

    public static final double[] vabs(double[] e) {
        double[] v = new double[e.length];
        for (int i = 0; i < e.length; ++i) {
            v[i] = Math.abs(e[i]);
        }
        return v;
    }

    public static final double[] vexp(double[] e) {
        double[] v = new double[e.length];
        for (int i = 0; i < e.length; ++i) {
            v[i] = Math.exp(e[i]);
        }
        return v;
    }

    public static final double[] vlog(double[] e) {
        double[] v = new double[e.length];
        for (int i = 0; i < e.length; ++i) {
            v[i] = Math.log(e[i]);
        }
        return v;
    }

    public static final double[] vlog1pComps(double[] e) {
        double[] v = new double[e.length];
        for (int i = 0; i < e.length; ++i) {
            v[i] = Math.log1p(-e[i]);
        }
        return v;
    }

    public static final double[] vsignif(double[] e, int digits) {
        double[] v = new double[e.length];
        for (int i = 0; i < e.length; ++i) {
            v[i] = MathFunctions.signif(e[i], digits);
        }
        return v;
    }

    public static final double[] diff(double[] e, int lag, int order) {
        double[] v = new double[e.length];
        System.arraycopy(e, 0, v, 0, e.length);
        int vlen = v.length;
        int i = 0;
        while (i < order) {
            for (int j = lag; j < vlen; ++j) {
                v[j - lag] = v[j] - v[j - lag];
            }
            ++i;
            vlen -= lag;
        }
        e = new double[e.length - lag * order];
        System.arraycopy(v, 0, e, 0, e.length);
        return e;
    }

    public static final double[] diff(double[] e, int lag) {
        return VectorMath.diff(e, lag, 1);
    }

    public static final double[] diff(double[] e) {
        return VectorMath.diff(e, 1, 1);
    }

    public static final boolean allFinite(double[] e) {
        for (double _e : e) {
            if (!MathFunctions.isInfinite(_e)) continue;
            return false;
        }
        return true;
    }

    public static final boolean allLt(double[] e, double v) {
        for (double _e : e) {
            if (!(_e >= v)) continue;
            return false;
        }
        return true;
    }

    public static final boolean allGt(double[] e, double v) {
        for (double _e : e) {
            if (!(_e <= v)) continue;
            return false;
        }
        return true;
    }

    public static final boolean allEq(double[] e, double v) {
        for (double _e : e) {
            if (_e == v) continue;
            return false;
        }
        return true;
    }

    public static final boolean allEqual(double[] e, double[] v) {
        if (e.length != v.length) {
            throw new RuntimeException();
        }
        int n = e.length;
        for (int i = 0; i < n; ++i) {
            if (e[i] == v[i]) continue;
            return false;
        }
        return true;
    }

    public static final double quantile(double[] sortedData, double quantile) {
        double index = (double)(sortedData.length - 1) * quantile;
        int lo = (int)Math.floor(index);
        int hi = (int)Math.ceil(index);
        if (lo < 0) {
            return 0.0;
        }
        double h = index - (double)lo;
        double lowerQ = sortedData[lo];
        double result = h == 0.0 ? lowerQ : (1.0 - h) * lowerQ + h * sortedData[hi];
        return result;
    }

    public static final double[] quantile(double[] sortedData, double[] quantile) {
        double[] v = new double[quantile.length];
        for (int i = 0; i < quantile.length; ++i) {
            v[i] = VectorMath.quantile(sortedData, quantile[i]);
        }
        return v;
    }

    public static final double quantile0(double[] e, double quantile) {
        int n = e.length;
        double[] r = new double[n];
        System.arraycopy(e, 0, r, 0, n);
        Utilities.sort(r);
        return VectorMath.quantile(r, quantile);
    }

    public static final double[] quantile0(double[] e, double[] quantile) {
        int n = e.length;
        double[] r = new double[n];
        System.arraycopy(e, 0, r, 0, n);
        Utilities.sort(r);
        double[] v = new double[quantile.length];
        for (int i = 0; i < quantile.length; ++i) {
            v[i] = VectorMath.quantile(r, quantile[i]);
        }
        return v;
    }

    public static final double mean(double[] e) {
        double sum = 0.0;
        int n = e.length;
        for (int i = 0; i < n; ++i) {
            sum += e[i] / (double)n;
        }
        return sum;
    }

    public static final double median(double[] e) {
        int n = e.length;
        double[] v = new double[e.length];
        System.arraycopy(e, 0, v, 0, n);
        Utilities.sort(v);
        return VectorMath.quantile(v, 0.5);
    }

    public static final double sd(double[] e) {
        double sum = 0.0;
        double sumsq = 0.0;
        int n = e.length;
        int nm1 = n - 1;
        for (int i = 0; i < n; ++i) {
            double v = e[i];
            sum += v / (double)n;
            sumsq += v * v / (double)nm1;
        }
        return Math.sqrt(sumsq - sum / (double)nm1 * sum * (double)n);
    }

    public static final double var(double[] e) {
        double sum = 0.0;
        double sumsq = 0.0;
        int n = e.length;
        int nm1 = n - 1;
        for (int i = 0; i < n; ++i) {
            double v = e[i];
            sum += v / (double)n;
            sumsq += v * v / (double)nm1;
        }
        return sumsq - sum / (double)nm1 * sum * (double)n;
    }

    public static final double sum(double[] e) {
        double sum = 0.0;
        int n = e.length;
        for (int i = 0; i < n; ++i) {
            sum += e[i];
        }
        return sum;
    }

    public static final double sum(Map<String, Integer> e) {
        double sum = 0.0;
        for (int v : e.values()) {
            sum += (double)v;
        }
        return sum;
    }

    public static final Map<String, Integer> table(double[] e) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (double _e : e) {
            String estr;
            Integer i = (Integer)map.get(estr = String.valueOf(_e));
            map.put(estr, 1 + (i == null ? 0 : i));
        }
        return map;
    }

    public static final <T> Map<String, Integer> table(T[] e) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (T _e : e) {
            String estr;
            Integer i = (Integer)map.get(estr = String.valueOf(_e));
            map.put(estr, 1 + (i == null ? 0 : i));
        }
        return map;
    }

    public static final double[] as_numeric(Collection<String> ll) {
        int n = ll.size();
        int i = 0;
        double[] v = new double[n];
        for (String str : ll) {
            v[i] = Double.valueOf(str);
            ++i;
        }
        return v;
    }

    public static final double[] cumsum(double[] e) {
        int n = e.length;
        double[] r = new double[n];
        r[0] = e[0];
        for (int i = 1; i < n; ++i) {
            r[i] = r[i - 1] + e[i];
        }
        return r;
    }

    public static final int[] cumsum(int[] e) {
        int n = e.length;
        int[] r = new int[n];
        r[0] = e[0];
        for (int i = 1; i < n; ++i) {
            r[i] = r[i - 1] + e[i];
        }
        return r;
    }

    public static final double max(double[] e) {
        int n = e.length;
        double mx = e[0];
        for (int i = 1; i < n; ++i) {
            if (!(e[i] > mx)) continue;
            mx = e[i];
        }
        return mx;
    }

    public static final double min(double[] e) {
        int n = e.length;
        double mn = e[0];
        for (int i = 1; i < n; ++i) {
            if (!(e[i] < mn)) continue;
            mn = e[i];
        }
        return mn;
    }

    public static final int which_max(double[] e) {
        int n = e.length;
        int which = 0;
        double mx = e[0];
        for (int i = 1; i < n; ++i) {
            if (!(e[i] > mx)) continue;
            mx = e[i];
            which = i;
        }
        return which;
    }

    public static final int which_min(double[] e) {
        int n = e.length;
        int which = 0;
        double mn = e[0];
        for (int i = 1; i < n; ++i) {
            if (!(e[i] < mn)) continue;
            mn = e[i];
            which = i;
        }
        return which;
    }

    public static final double[] pmax(double[] a, double[] b) {
        int n = a.length;
        if (n != b.length) {
            throw new RuntimeException();
        }
        double[] mx = new double[n];
        for (int i = 0; i < n; ++i) {
            mx[i] = a[i] > b[i] ? a[i] : b[i];
        }
        return mx;
    }

    public static final double[] pmin(double[] a, double[] b) {
        int n = a.length;
        if (n != b.length) {
            throw new RuntimeException();
        }
        double[] mx = new double[n];
        for (int i = 0; i < n; ++i) {
            mx[i] = a[i] < b[i] ? a[i] : b[i];
        }
        return mx;
    }

    public static final double[] range(double[] e) {
        int n = e.length;
        double mx = e[0];
        double mn = e[0];
        for (int i = 1; i < n; ++i) {
            if (e[i] > mx) {
                mx = e[i];
                continue;
            }
            if (!(e[i] < mn)) continue;
            mn = e[i];
        }
        return new double[]{mn, mx};
    }

    public static final boolean isEqual(double a, double b, double tol) {
        return Double.isNaN(a) && Double.isNaN(b) || a == b || Math.abs(a - b) <= tol;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEqualScaled(double a, double b, double tol) {
        if (Double.isNaN(a)) {
            if (Double.isNaN(b)) return true;
        }
        if (a == b) return true;
        double d = Math.abs(a - b);
        double d2 = Double.isNaN(a) ? 0.0 : a;
        if (!(d / d2 <= tol)) return false;
        return true;
    }

    public static final boolean allEqual(double[] a, double[] b, double tol) {
        int n = a.length;
        if (n != b.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < n; ++i) {
            if (VectorMath.isEqual(a[i], b[i], tol)) continue;
            return false;
        }
        return true;
    }

    public static final boolean allEqualScaled(double[] a, double[] b, double tol) {
        int n = a.length;
        if (n != b.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < n; ++i) {
            if (VectorMath.isEqualScaled(a[i], b[i], tol)) continue;
            return false;
        }
        return true;
    }
}

