/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.ChiSquare;
import jdistlib.matrix.QMatrixUtils;
import jdistlib.rng.RandomEngine;

public class Wishart {
    public static final double[][] random(double n, double[][] L, RandomEngine rand) {
        int i;
        int d = L.length;
        assert (d == L[0].length);
        double[][] z = new double[d][d];
        double[] y = new double[d];
        double[][] B = new double[d][d];
        for (i = 1; i < d; ++i) {
            for (int j = 0; j < i; ++j) {
                z[i][j] = rand.nextGaussian();
            }
        }
        for (i = 0; i < d; ++i) {
            double sum = y[i] = ChiSquare.random(n - (double)i + 1.0, rand);
            for (int j = 0; j < i; ++j) {
                double val = z[j][i];
                sum += val * val;
            }
            B[i][i] = sum / n;
            if (i <= 0) continue;
            double d2 = z[i][0] * Math.sqrt(y[0]) / n;
            B[i][0] = d2;
            B[0][i] = d2;
        }
        for (i = 2; i < d; ++i) {
            for (int j = 1; j < i; ++j) {
                double sum = z[i][j] * Math.sqrt(y[j]);
                for (int k = 0; k < j; ++k) {
                    sum += z[i][k] * z[j][k];
                }
                double d3 = sum / n;
                B[j][i] = d3;
                B[i][j] = d3;
            }
        }
        return QMatrixUtils.calculateXYt(QMatrixUtils.calculateXY(L, B), L);
    }
}

