/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import java.util.Arrays;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class Ansari
extends GenericDistribution {
    protected int m;
    protected int n;
    protected double[][][] w;

    static final double cansari(int k, int m, int n, double[][][] w) {
        int l = (m + 1) * (m + 1) / 4;
        int u = l + m * n / 2;
        if (k < l || k > u) {
            return 0.0;
        }
        if (w[m][n] == null) {
            w[m][n] = new double[u + 1];
            Arrays.fill(w[m][n], -1.0);
        }
        if (w[m][n][k] < 0.0) {
            w[m][n][k] = m == 0 ? (k == 0 ? 1.0 : 0.0) : (n == 0 ? (k == l ? 1.0 : 0.0) : Ansari.cansari(k, m, n - 1, w) + Ansari.cansari(k - (m + n + 1) / 2, m - 1, n, w));
        }
        return w[m][n][k];
    }

    public static final double[] density(int[] x, int m, int n) {
        int len = x.length;
        double[][][] w = new double[m + 1][n + 1][];
        double[] result = new double[len];
        for (int i = 0; i < len; ++i) {
            result[i] = Ansari.cansari(x[i], m, n, w) / MathFunctions.choose(m + n, m);
        }
        return result;
    }

    static final double density(int x, int m, int n, double[][][] w) {
        return Ansari.cansari(x, m, n, w) / MathFunctions.choose(m + n, m);
    }

    public static final double density(int x, int m, int n) {
        return Ansari.cansari(x, m, n, new double[m + 1][n + 1][]) / MathFunctions.choose(m + n, m);
    }

    public static final double[] cumulative(int[] x, int m, int n) {
        return Ansari.cumulative(x, m, n, (double[][][])null, true);
    }

    public static final double cumulative(int x, int m, int n, boolean lower_tail) {
        return Ansari.cumulative(x, m, n, (double[][][])null, lower_tail);
    }

    public static final double[] cumulative(int[] x, int m, int n, boolean lower_tail) {
        return Ansari.cumulative(x, m, n, (double[][][])null, lower_tail);
    }

    static final double[] cumulative(int[] x, int m, int n, double[][][] w, boolean lower_tail) {
        int len = x.length;
        double[] result = new double[len];
        if (w == null) {
            w = new double[m + 1][n + 1][];
        }
        int l = (m + 1) * (m + 1) / 4;
        int u = l + m * n / 2;
        double c = MathFunctions.choose(m + n, m);
        for (int i = 0; i < len; ++i) {
            if (x[i] < l) {
                result[i] = 0.0;
                continue;
            }
            if (x[i] > u) {
                result[i] = 1.0;
                continue;
            }
            int qq = x[i];
            double p = 0.0;
            for (int j = l; j <= qq; ++j) {
                p += Ansari.cansari(j, m, n, w);
            }
            result[i] = lower_tail ? p / c : 1.0 - p / c;
        }
        return result;
    }

    public static final double cumulative(int x, int m, int n) {
        return Ansari.cumulative(x, m, n, null);
    }

    public static final double cumulative(int x, int m, int n, double[][][] w) {
        return Ansari.cumulative(x, m, n, w, true);
    }

    public static final double cumulative(int x, int m, int n, double[][][] w, boolean lower_tail) {
        if (w == null) {
            w = new double[m + 1][n + 1][];
        }
        int l = (m + 1) * (m + 1) / 4;
        int u = l + m * n / 2;
        double c = MathFunctions.choose(m + n, m);
        if (x < l) {
            return 0.0;
        }
        if (x > u) {
            return 1.0;
        }
        double p = 0.0;
        for (int j = l; j <= x; ++j) {
            p += Ansari.cansari(j, m, n, w);
        }
        return p / c;
    }

    public static final int[] quantile(double[] x, int m, int n) {
        return Ansari.quantile(x, m, n, (double[][][])null);
    }

    public static final int[] quantile(double[] x, int m, int n, double[][][] w) {
        int len = x.length;
        int[] result = new int[len];
        if (w == null) {
            w = new double[m + 1][n + 1][];
        }
        int l = (m + 1) * (m + 1) / 4;
        int u = l + m * n / 2;
        double c = MathFunctions.choose(m + n, m);
        for (int i = 0; i < len; ++i) {
            double xi = x[i];
            if (xi < 0.0 || xi > 1.0) {
                System.err.println("probabilities outside [0,1] in Ansari.quantile");
                result[i] = Integer.MIN_VALUE;
            }
            if (xi == 0.0) {
                result[i] = l;
                continue;
            }
            if (xi == 1.0) {
                result[i] = u;
                continue;
            }
            double p = 0.0;
            int q = 0;
            while (!((p += Ansari.cansari(q, m, n, w) / c) >= xi)) {
                ++q;
            }
            result[i] = q;
        }
        return result;
    }

    public static final int quantile(double x, int m, int n) {
        return Ansari.quantile(x, m, n, new double[m + 1][n + 1][]);
    }

    public static final int quantile(double xi, int m, int n, double[][][] w) {
        if (w == null) {
            w = new double[m + 1][n + 1][];
        }
        int l = (m + 1) * (m + 1) / 4;
        int u = l + m * n / 2;
        double c = MathFunctions.choose(m + n, m);
        if (xi < 0.0 || xi > 1.0) {
            System.err.println("probabilities outside [0,1] in Ansari.quantile");
            return Integer.MIN_VALUE;
        }
        if (xi == 0.0) {
            return l;
        }
        if (xi == 1.0) {
            return u;
        }
        double p = 0.0;
        int q = 0;
        while (!((p += Ansari.cansari(q, m, n, w) / c) >= xi)) {
            ++q;
        }
        return q;
    }

    public static final double random(int m, int n, RandomEngine random) {
        double u1 = random.nextDouble();
        u1 = (double)((int)(1.34217728E8 * u1)) + random.nextDouble();
        u1 = Ansari.quantile(u1 / 1.34217728E8, m, n);
        return u1;
    }

    public static final double random(int m, int n, double[][][] w, RandomEngine random) {
        double u1 = random.nextDouble();
        u1 = (double)((int)(1.34217728E8 * u1)) + random.nextDouble();
        u1 = Ansari.quantile(u1 / 1.34217728E8, m, n, w);
        return u1;
    }

    public static final double[] random(int count, int m, int n, RandomEngine random) {
        return Ansari.random(count, m, n, null, random);
    }

    public static final double[] random(int count, int m, int n, double[][][] w, RandomEngine random) {
        double[] rand = new double[count];
        for (int i = 0; i < count; ++i) {
            double u1 = random.nextDouble();
            rand[i] = u1 = ((double)((int)(1.34217728E8 * u1)) + random.nextDouble()) / 1.34217728E8;
        }
        int[] q = Ansari.quantile(rand, m, n, w);
        for (int i = 0; i < count; ++i) {
            rand[i] = q[i];
        }
        return rand;
    }

    public Ansari(int m, int n) {
        this.m = m;
        this.n = n;
        this.w = new double[m + 1][n + 1][];
    }

    public double density(double x, boolean log) {
        return Ansari.density((int)x, this.m, this.n, this.w);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        p = Ansari.cumulative((int)p, this.m, this.n, this.w, lower_tail);
        return log_p ? Math.log(p) : p;
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        if (log_p) {
            q = Math.exp(q);
        }
        if (log_p) {
            q = Math.exp(q);
        }
        if (!lower_tail) {
            q = 1.0 - q;
        }
        return Ansari.quantile(q, this.m, this.n, this.w);
    }

    public double random() {
        return Ansari.random(this.m, this.n, this.w, this.random);
    }
}

