/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.matrix;

public class QMatrixUtils {
    public static final double[][] calculateXY(double[][] X, double[][] Y) {
        int rows = X.length;
        int m = Y.length;
        int cols = Y[0].length;
        assert (m == X.length);
        double[][] result = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            double[] Xrow = X[i];
            for (int j = 0; j < cols; ++j) {
                double sum = 0.0;
                for (int k = 0; k < m; ++k) {
                    sum += Xrow[k] * Y[k][j];
                }
                result[i][j] = sum;
            }
        }
        return result;
    }

    public static final double[][] calculateXYt(double[][] X, double[][] Y) {
        int rows = X.length;
        int m = Y[0].length;
        int cols = Y.length;
        assert (m == X.length);
        double[][] result = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            double[] Xrow = X[i];
            for (int j = 0; j < cols; ++j) {
                double sum = 0.0;
                double[] Yrow = Y[j];
                for (int k = 0; k < m; ++k) {
                    sum += Xrow[k] * Yrow[k];
                }
                result[i][j] = sum;
            }
        }
        return result;
    }

    public static final double[][] calculateXtY(double[][] X, double[][] Y) {
        int rows = X[0].length;
        int m = Y.length;
        int cols = Y[0].length;
        assert (m == X.length);
        double[][] result = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                double sum = 0.0;
                for (int k = 0; k < m; ++k) {
                    sum += X[k][i] * Y[k][j];
                }
                result[i][j] = sum;
            }
        }
        return result;
    }
}

