/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.evd;

import jdistlib.Exponential;
import jdistlib.rng.QRandomEngine;

public class ReverseWeibull {
    public static final double density(double x, double loc, double scale, double shape, boolean log) {
        if (scale <= 0.0 || shape <= 0.0) {
            return Double.NaN;
        }
        if ((x = (x - loc) / scale) >= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        x = Math.log(shape / scale) + (shape - 1.0) * Math.log(-x) - Math.pow(-x, shape);
        return !log ? Math.exp(x) : x;
    }

    public static final double cumulative(double q, double loc, double scale, double shape, boolean lower_tail) {
        if (scale <= 0.0 || shape <= 0.0) {
            return Double.NaN;
        }
        q = Math.exp(-Math.pow(-Math.min((q - loc) / scale, 0.0), shape));
        return !lower_tail ? 1.0 - q : q;
    }

    public static final double quantile(double p, double loc, double scale, double shape, boolean lower_tail) {
        if (p <= 0.0 || p >= 1.0 || scale < 0.0 || shape <= 0.0) {
            return Double.NaN;
        }
        if (!lower_tail) {
            p = 1.0 - p;
        }
        return loc - scale * Math.pow(-Math.log(p), 1.0 / shape);
    }

    public static final double random(double loc, double scale, double shape, QRandomEngine random) {
        if (scale < 0.0 || shape <= 0.0) {
            return Double.NaN;
        }
        return loc - scale * Math.pow(Exponential.random_standard(random), 1.0 / shape);
    }
}

