/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.evd;

import jdistlib.MathFunctions;
import jdistlib.generic.GenericDistribution;

public class Order {
    public static final double density(double x, GenericDistribution dist, int mlen, int j, boolean largest, boolean log) {
        double dens;
        if (mlen <= 0 || j <= 0 || j > mlen) {
            return Double.NaN;
        }
        if (!largest) {
            j = mlen + 1 - j;
        }
        if (Double.isInfinite(dens = dist.density(x, true))) {
            return Double.NEGATIVE_INFINITY;
        }
        double cum = dist.cumulative(x, true);
        cum = (double)(mlen - j) * Math.log(cum) + (double)(j - 1) * Math.log(1.0 - cum);
        x = MathFunctions.lgammafn(mlen + 1) - MathFunctions.lgammafn(j) - MathFunctions.lgammafn(mlen - j + 1) + dens + cum;
        return !log ? Math.exp(x) : x;
    }

    public static final double cumulative(double q, GenericDistribution dist, int mlen, int j, boolean largest, boolean lower_tail) {
        if (mlen <= 0 || j <= 0 || j > mlen) {
            return Double.NaN;
        }
        return 0.0;
    }
}

