/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.disttest;

import java.util.Arrays;
import jdistlib.disttest.Utils;

public class DistributionTest {
    public static final double kolmogorov_smirnov_statistic(double[] X, double[] Y) {
        int nX = X.length;
        int nY = Y.length;
        int idxX = 0;
        int idxY = 0;
        double[] sortedX = (double[])X.clone();
        double[] sortedY = (double[])Y.clone();
        double maxDiv = 0.0;
        Arrays.sort(sortedX);
        Arrays.sort(sortedY);
        if (sortedX[nX - 1] < sortedY[0] || sortedY[nY - 1] < sortedX[0]) {
            return 1.0;
        }
        double[] cdfX = Utils.calculate_ecdf(sortedX);
        double[] cdfY = Utils.calculate_ecdf(sortedY);
        double pX = 0.0;
        double pY = 0.0;
        double div = 0.0;
        while (idxX < nX && idxY < nY) {
            double y = sortedY[idxY];
            double x = sortedX[idxX];
            if (y < x) {
                pY = cdfY[idxY];
                ++idxY;
            } else if (y > x) {
                pX = cdfX[idxX];
                ++idxX;
            } else {
                pX = cdfX[idxX];
                pY = cdfY[idxY];
                ++idxX;
                ++idxY;
            }
            if (!((div = Math.abs(pX - pY)) > maxDiv)) continue;
            maxDiv = div;
        }
        return maxDiv;
    }

    public static final double kolmogorov_smirnov_pvalue(double maxDiv, int lengthX, int lengthY) {
        if (lengthX > lengthY) {
            int temp = lengthY;
            lengthY = lengthX;
            lengthX = temp;
        }
        double q = Math.floor(maxDiv * (double)lengthX * (double)lengthY - 1.0E-7) / (double)(lengthX * lengthY);
        double[] u = new double[lengthY + 1];
        double md = lengthX;
        double nd = lengthY;
        for (int j = 0; j <= lengthY; ++j) {
            u[j] = (double)j / nd > q ? 0.0 : 1.0;
        }
        for (int i = 1; i <= lengthX; ++i) {
            double w = (double)i / (double)(i + lengthY);
            u[0] = (double)i / md > q ? 0.0 : w * u[0];
            for (int j = 1; j <= lengthY; ++j) {
                u[j] = Math.abs((double)i / md - (double)j / nd) > q ? 0.0 : w * u[j] + u[j - 1];
            }
        }
        return 1.0 - u[lengthY];
    }
}

