/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.rng.QRandomEngine;

public class Weibull {
    public static final double density(double x, double shape, double scale, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(shape) || Double.isNaN(scale)) {
            return x + shape + scale;
        }
        if (shape <= 0.0 || scale <= 0.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (Double.isInfinite(x)) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (x == 0.0 && shape < 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double tmp1 = Math.pow(x / scale, shape - 1.0);
        double tmp2 = tmp1 * (x / scale);
        return give_log ? -tmp2 + Math.log(shape * tmp1 / scale) : shape * tmp1 * Math.exp(-tmp2) / scale;
    }

    public static final double cumulative(double x, double shape, double scale, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(shape) || Double.isNaN(scale)) {
            return x + shape + scale;
        }
        if (shape <= 0.0 || scale <= 0.0) {
            return Double.NaN;
        }
        if (x <= 0.0) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        x = -Math.pow(x / scale, shape);
        if (lower_tail) {
            return log_p ? (x > -0.6931471805599453 ? Math.log(-Math.expm1(x)) : Math.log1p(-Math.exp(x))) : -Math.expm1(x);
        }
        return log_p ? x : Math.exp(x);
    }

    public static final double quantile(double p, double shape, double scale, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(p) || Double.isNaN(shape) || Double.isNaN(scale)) {
            return p + shape + scale;
        }
        if (shape <= 0.0 || scale <= 0.0) {
            return Double.NaN;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
        }
        p = lower_tail ? (log_p ? (p > -0.6931471805599453 ? Math.log(-Math.expm1(p)) : Math.log1p(-Math.exp(p))) : Math.log1p(-p)) : (log_p ? p : Math.log(p));
        return scale * Math.pow(-p, 1.0 / shape);
    }

    public static final double random(double shape, double scale, QRandomEngine random) {
        if (Double.isInfinite(shape) || Double.isInfinite(scale) || shape <= 0.0 || scale <= 0.0) {
            if (scale == 0.0) {
                return 0.0;
            }
            return Double.NaN;
        }
        return scale * Math.pow(-Math.log(random.nextDouble()), 1.0 / shape);
    }
}

