/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Beta;
import jdistlib.MathFunctions;
import jdistlib.NonCentralChiSquare;
import jdistlib.Poisson;
import jdistlib.rng.QRandomEngine;

public class NonCentralBeta {
    public static final double density(double x, double a, double b, double ncp, boolean give_log) {
        double q;
        double eps = 1.0E-15;
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(ncp)) {
            return x + a + b + ncp;
        }
        if (ncp < 0.0 || a <= 0.0 || b <= 0.0) {
            return Double.NaN;
        }
        if (Double.isInfinite(a) || Double.isInfinite(b) || Double.isInfinite(ncp)) {
            return Double.NaN;
        }
        if (x < 0.0 || x > 1.0) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (ncp == 0.0) {
            return Beta.density(x, a, b, give_log);
        }
        double ncp2 = 0.5 * ncp;
        double dx2 = ncp2 * x;
        double d = (dx2 - a - 1.0) / 2.0;
        double D = d * d + dx2 * (a + b) - a;
        int kMax = D <= 0.0 ? 0 : ((D = Math.ceil(d + Math.sqrt(D))) > 0.0 ? (int)D : 0);
        double term = Beta.density(x, a + (double)kMax, b, true);
        double p_k = Poisson.density_raw(kMax, ncp2, true);
        if (x == 0.0 || Double.isInfinite(term) || Double.isInfinite(p_k)) {
            return give_log ? p_k + term : Math.exp(p_k + term);
        }
        p_k += term;
        term = 1.0;
        double sum = 1.0;
        double k = kMax;
        while (k > 0.0 && term > sum * 1.0E-15) {
            q = ((k -= 1.0) + 1.0) * (k + a) / (k + a + b) / dx2;
            sum += (term *= q);
        }
        term = 1.0;
        k = kMax;
        do {
            q = dx2 * (k + a + b) / (k + a) / (k + 1.0);
            k += 1.0;
        } while ((term *= q) > (sum += term) * 1.0E-15);
        return give_log ? p_k + Math.log(sum) : Math.exp(p_k + Math.log(sum));
    }

    public static final double cumulative_raw(double x, double o_x, double a, double b, double ncp) {
        double errbd;
        double ax;
        double errmax = 1.0E-9;
        int itrmax = 10000;
        if (ncp < 0.0 || a <= 0.0 || b <= 0.0) {
            return Double.NaN;
        }
        if (x < 0.0 || o_x > 1.0 || x == 0.0 && o_x == 1.0) {
            return 0.0;
        }
        if (x > 1.0 || o_x < 0.0 || x == 1.0 && o_x == 0.0) {
            return 1.0;
        }
        double c = ncp / 2.0;
        double x0 = Math.floor(Math.max(c - 7.0 * Math.sqrt(c), 0.0));
        double a0 = a + x0;
        double lbeta = MathFunctions.lgammafn(a0) + MathFunctions.lgammafn(b) - MathFunctions.lgammafn(a0 + b);
        double[] tt = MathFunctions.bratio(a0, b, x, o_x, false);
        double temp = tt[0];
        double gx = Math.exp(a0 * Math.log(x) + b * (x < 0.5 ? Math.log1p(-x) : Math.log(o_x)) - lbeta - Math.log(a0));
        double q = a0 > a ? Math.exp(-c + x0 * Math.log(c) - MathFunctions.lgammafn(x0 + 1.0)) : Math.exp(-c);
        double sumq = 1.0 - q;
        double ans = ax = q * temp;
        int j = (int)x0;
        do {
            ax = (temp -= (gx *= x * (a + b + (double)(++j) - 1.0) / (a + (double)j))) * q;
            ans += ax;
        } while ((errbd = (temp - gx) * (sumq -= (q *= c / (double)j))) > 1.0E-9 && (double)j < 10000.0 + x0);
        if (errbd > 1.0E-9) {
            System.err.println("Precision error NonCentralBeta.cumulative");
        }
        if ((double)j >= 10000.0 + x0) {
            System.err.println("Non-convergence error NonCentralBeta.cumulative");
        }
        return ans;
    }

    static final double pnbeta2(double x, double o_x, double a, double b, double ncp, boolean lower_tail, boolean log_p) {
        double ans = NonCentralBeta.cumulative_raw(x, o_x, a, b, ncp);
        if (lower_tail) {
            return log_p ? Math.log(ans) : ans;
        }
        if (ans > 0.9999999999) {
            System.err.println("Precision error NonCentralBeta.cumulative");
        }
        ans = Math.min(ans, 1.0);
        return log_p ? Math.log1p(-ans) : 1.0 - ans;
    }

    public static final double cumulative(double x, double a, double b, double ncp, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(ncp)) {
            return x + a + b + ncp;
        }
        if (x <= 0.0) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        if (x >= 1.0) {
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        return NonCentralBeta.pnbeta2(x, 1.0 - x, a, b, ncp, lower_tail, log_p);
    }

    public static final double quantile(double p, double a, double b, double ncp, boolean lower_tail, boolean log_p) {
        double nx;
        double lx;
        double accu = 1.0E-15;
        double Eps = 1.0E-14;
        if (Double.isNaN(p) || Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(ncp)) {
            return p + a + b + ncp;
        }
        if (Double.isInfinite(a)) {
            return Double.NaN;
        }
        if (ncp < 0.0 || a <= 0.0 || b <= 0.0) {
            return Double.NaN;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? 1.0 : 0.0;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? 0.0 : 1.0;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? 0.0 : 1.0;
            }
            if (p == 1.0) {
                return lower_tail ? 1.0 : 0.0;
            }
        }
        double d = log_p ? (lower_tail ? Math.exp(p) : -Math.expm1(p)) : (p = lower_tail ? p : 0.5 - p + 0.5);
        if (p > 0.9999999999999998) {
            return 1.0;
        }
        double pp = Math.min(0.9999999999999998, p * 1.00000000000001);
        double ux = 0.5;
        while (ux < 0.9999999999999998 && NonCentralBeta.cumulative(ux, a, b, ncp, true, false) < pp) {
            ux = 0.5 * (1.0 + ux);
        }
        pp = p * 0.99999999999999;
        for (lx = 0.5; lx > Double.MIN_VALUE && NonCentralBeta.cumulative(lx, a, b, ncp, true, false) > pp; lx *= 0.5) {
        }
        do {
            if (NonCentralBeta.cumulative(nx = 0.5 * (lx + ux), a, b, ncp, true, false) > p) {
                ux = nx;
                continue;
            }
            lx = nx;
        } while ((ux - lx) / nx > 1.0E-15);
        return 0.5 * (ux + lx);
    }

    public static final double random(double a, double b, double ncp, QRandomEngine random) {
        if (ncp == 0.0) {
            return Beta.random(a, b, random);
        }
        double x = NonCentralChiSquare.random(2.0 * a, ncp, random);
        x /= x + NonCentralChiSquare.random(2.0 * b, ncp, random);
        return x;
    }
}

