/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Beta;
import jdistlib.Binomial;
import jdistlib.Gamma;
import jdistlib.MathFunctions;
import jdistlib.Normal;
import jdistlib.Poisson;
import jdistlib.rng.QRandomEngine;

public class NegBinomial {
    public static final double density(double x, double size, double prob, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(size) || Double.isNaN(prob)) {
            return x + size + prob;
        }
        if (prob <= 0.0 || prob > 1.0 || size < 0.0) {
            return Double.NaN;
        }
        if (Math.abs(x - Math.floor(x + 0.5)) > 1.0E-7) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (x < 0.0 || Double.isInfinite(x)) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        x = Math.floor(x + 0.5);
        double ans = Binomial.density_raw(size, x + size, prob, 1.0 - prob, give_log);
        double p = size / (size + x);
        return give_log ? Math.log(p) + ans : p * ans;
    }

    public static final double density_mu(double x, double size, double mu, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(size) || Double.isNaN(size)) {
            return x + size + mu;
        }
        if (mu < 0.0 || size < 0.0) {
            return Double.NaN;
        }
        if (Math.abs(x - Math.floor(x + 0.5)) > 1.0E-7) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (x < 0.0 || Double.isInfinite(x)) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if ((x = Math.floor(x + 0.5)) == 0.0) {
            x = size * (size < mu ? Math.log(size / (size + mu)) : Math.log1p(-mu / (size + mu)));
            return give_log ? x : Math.exp(x);
        }
        if (x < 1.0E-10 * size) {
            x = x * Math.log(size * mu / (size + mu)) - mu - MathFunctions.lgammafn(x + 1.0) + Math.log1p(x * (x - 1.0) / (2.0 * size));
            return give_log ? x : Math.exp(x);
        }
        double ans = Binomial.density_raw(size, x + size, size / (size + mu), mu / (size + mu), give_log);
        double p = size / (size + x);
        return give_log ? Math.log(p) + ans : p * ans;
    }

    public static final double cumulative(double x, double size, double prob, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(size) || Double.isNaN(prob)) {
            return x + size + prob;
        }
        if (Double.isInfinite(size) || Double.isInfinite(prob)) {
            return Double.NaN;
        }
        if (size <= 0.0 || prob <= 0.0 || prob > 1.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        if (Double.isInfinite(x)) {
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        x = Math.floor(x + 1.0E-7);
        return Beta.cumulative(prob, size, x + 1.0, lower_tail, log_p);
    }

    public static final double cumulative_mu(double x, double size, double mu, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(size) || Double.isNaN(size)) {
            return x + size + mu;
        }
        if (Double.isInfinite(size) || Double.isInfinite(mu)) {
            return Double.NaN;
        }
        if (size <= 0.0 || mu < 0.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        if (Double.isInfinite(x)) {
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        x = Math.floor(x + 1.0E-7);
        double[] temp = MathFunctions.bratio(size, x + 1.0, size / (size + mu), mu / (size + mu), log_p);
        double w = temp[0];
        double wc = temp[1];
        return lower_tail ? w : wc;
    }

    static final double do_search(double y, double[] z, double p, double n, double pr, double incr) {
        double d;
        block4: {
            if (!(z[0] >= p)) break block4;
            while (true) {
                block6: {
                    block5: {
                        double d2;
                        if (y == 0.0) break block5;
                        z[0] = NegBinomial.cumulative(y - incr, n, pr, true, false);
                        if (!(d2 < p)) break block6;
                    }
                    return y;
                }
                y = Math.max(0.0, y - incr);
            }
        }
        do {
            z[0] = NegBinomial.cumulative(y += incr, n, pr, true, false);
        } while (!(d >= p));
        return y;
    }

    public static final double quantile(double p, double size, double prob, boolean lower_tail, boolean log_p) {
        double oldincr;
        if (Double.isNaN(p) || Double.isNaN(size) || Double.isNaN(prob)) {
            return p + size + prob;
        }
        if (prob <= 0.0 || prob > 1.0 || size <= 0.0) {
            return Double.NaN;
        }
        if (prob == 1.0) {
            return 0.0;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
        }
        double Q = 1.0 / prob;
        double P = (1.0 - prob) * Q;
        double mu = size * P;
        double sigma = Math.sqrt(size * P * Q);
        double gamma = (Q + P) / sigma;
        if (!lower_tail || log_p) {
            double d = log_p ? (lower_tail ? Math.exp(p) : -Math.expm1(p)) : (p = lower_tail ? p : 0.5 - p + 0.5);
            if (p == (lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0))) {
                return 0.0;
            }
            if (p == (lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0))) {
                return Double.POSITIVE_INFINITY;
            }
        }
        if (p + 2.242650509742816E-16 >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double z = Normal.quantile(p, 0.0, 1.0, true, false);
        double y = Math.floor(mu + sigma * (z + gamma * (z * z - 1.0) / 6.0) + 0.5);
        z = NegBinomial.cumulative(y, size, prob, true, false);
        p *= 0.9999999999999858;
        double[] zp = new double[]{z};
        if (y < 100000.0) {
            return NegBinomial.do_search(y, zp, p, size, prob, 1.0);
        }
        double incr = Math.floor(y * 0.001);
        do {
            oldincr = incr;
            y = NegBinomial.do_search(y, zp, p, size, prob, incr);
            incr = Math.max(1.0, Math.floor(incr / 100.0));
        } while (oldincr > 1.0 && incr > y * 1.0E-15);
        return y;
    }

    public static final double quantile_mu(double p, double size, double mu, boolean lower_tail, boolean log_p) {
        return NegBinomial.quantile(p, size, size / (size + mu), lower_tail, log_p);
    }

    public static final double random(double size, double prob, QRandomEngine random) {
        if (Double.isInfinite(size) || Double.isInfinite(prob) || size <= 0.0 || prob <= 0.0 || prob > 1.0) {
            return Double.NaN;
        }
        return prob == 1.0 ? 0.0 : Poisson.random(Gamma.random(size, (1.0 - prob) / prob, random), random);
    }
}

