/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.rng.QRandomEngine;

public class Logarithmic {
    public static final double density(double x, double mu, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(mu)) {
            return x + mu;
        }
        if (mu <= 0.0 || mu >= 1.0) {
            return Double.NaN;
        }
        double logfy = x * Math.log(mu) - Math.log(x) - Math.log(-Math.log(1.0 - mu));
        return give_log ? logfy : Math.exp(logfy);
    }

    public static final double cumulative(double q, double mu, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(q) || Double.isNaN(mu)) {
            return q + mu;
        }
        if (mu <= 0.0 || mu >= 1.0 || q <= 0.0) {
            return Double.NaN;
        }
        double sum = 0.0;
        int i = 0;
        while ((double)i < q) {
            sum += Logarithmic.density(i, mu, false);
            ++i;
        }
        sum = lower_tail ? sum : 1.0 - sum;
        return log_p ? Math.log(sum) : sum;
    }

    public static final double quantile(double p, double mu, boolean lower_tail, boolean log_p) {
        return Logarithmic.quantile(p, mu, lower_tail, log_p, 10000);
    }

    public static final double quantile(double p, double mu, boolean lower_tail, boolean log_p, int max_value) {
        if (Double.isNaN(p) || Double.isNaN(mu)) {
            return p + mu;
        }
        if (mu <= 0.0 || mu >= 1.0) {
            return Double.NaN;
        }
        if (p < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p > 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        p = log_p ? Math.exp(p) : p;
        p = lower_tail ? p : 1.0 - p;
        for (int i = 1; i <= max_value; ++i) {
            if (!(p <= Logarithmic.cumulative(i, mu, true, false))) continue;
            return i;
        }
        return Double.POSITIVE_INFINITY;
    }

    public static final double random(double mu, QRandomEngine random) {
        return Logarithmic.quantile(random.nextDouble(), mu, false, false);
    }
}

