/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.ITransaction;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.StoredObject;
import net.sf.webdav.exceptions.AccessDeniedException;
import net.sf.webdav.exceptions.LockFailedException;
import net.sf.webdav.exceptions.ObjectAlreadyExistsException;
import net.sf.webdav.exceptions.ObjectNotFoundException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.locking.ResourceLocks;
import net.sf.webdav.methods.AbstractMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoDelete
extends AbstractMethod {
    private static Logger LOG = LoggerFactory.getLogger(DoDelete.class);
    private IWebdavStore _store;
    private ResourceLocks _resourceLocks;
    private boolean _readOnly;

    public DoDelete(IWebdavStore store, ResourceLocks resourceLocks, boolean readOnly) {
        this._store = store;
        this._resourceLocks = resourceLocks;
        this._readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        LOG.trace("-- " + this.getClass().getName());
        if (!this._readOnly) {
            String path = this.getRelativePath(req);
            String parentPath = this.getParentPath(this.getCleanPath(path));
            Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
            if (!this.checkLocks(transaction, req, resp, this._resourceLocks, parentPath)) {
                resp.setStatus(423);
                return;
            }
            if (!this.checkLocks(transaction, req, resp, this._resourceLocks, path)) {
                resp.setStatus(423);
                return;
            }
            String tempLockOwner = "doDelete" + System.currentTimeMillis() + req.toString();
            if (this._resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) {
                try {
                    errorList = new Hashtable();
                    this.deleteResource(transaction, path, errorList, req, resp);
                    if (errorList.isEmpty()) return;
                    this.sendReport(req, resp, errorList);
                    return;
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                    return;
                }
                catch (ObjectAlreadyExistsException e) {
                    resp.sendError(404, req.getRequestURI());
                    return;
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                    return;
                }
                finally {
                    this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                }
            } else {
                resp.sendError(500);
            }
            return;
        } else {
            resp.sendError(403);
        }
    }

    public void deleteResource(ITransaction transaction, String path, Hashtable<String, Integer> errorList, HttpServletRequest req, HttpServletResponse resp) throws IOException, WebdavException {
        resp.setStatus(204);
        if (!this._readOnly) {
            StoredObject so = this._store.getStoredObject(transaction, path);
            if (so != null) {
                if (so.isResource()) {
                    this._store.removeObject(transaction, path);
                } else if (so.isFolder()) {
                    this.deleteFolder(transaction, path, errorList, req, resp);
                    this._store.removeObject(transaction, path);
                } else {
                    resp.sendError(404);
                }
            } else {
                resp.sendError(404);
            }
            so = null;
        } else {
            resp.sendError(403);
        }
    }

    private void deleteFolder(ITransaction transaction, String path, Hashtable<String, Integer> errorList, HttpServletRequest req, HttpServletResponse resp) throws WebdavException {
        String[] children = this._store.getChildrenNames(transaction, path);
        children = children == null ? new String[]{} : children;
        StoredObject so = null;
        for (int i = children.length - 1; i >= 0; --i) {
            children[i] = "/" + children[i];
            try {
                so = this._store.getStoredObject(transaction, path + children[i]);
                if (so.isResource()) {
                    this._store.removeObject(transaction, path + children[i]);
                    continue;
                }
                this.deleteFolder(transaction, path + children[i], errorList, req, resp);
                this._store.removeObject(transaction, path + children[i]);
                continue;
            }
            catch (AccessDeniedException e) {
                errorList.put(path + children[i], new Integer(403));
                continue;
            }
            catch (ObjectNotFoundException e) {
                errorList.put(path + children[i], new Integer(404));
                continue;
            }
            catch (WebdavException e) {
                errorList.put(path + children[i], new Integer(500));
            }
        }
        so = null;
    }
}

