/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.model.writer;

import fr.reseaumexico.model.Factor;
import fr.reseaumexico.model.Scenario;
import fr.reseaumexico.model.writer.MexicoXmlWriter;
import fr.reseaumexico.model.writer.XmlNode;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class ScenarioXmlWriter
extends MexicoXmlWriter<Scenario> {
    private final boolean standalone;

    public static void write(Scenario model, File exportFile) throws IOException {
        ScenarioXmlWriter writer = new ScenarioXmlWriter(model, true);
        writer.write(exportFile);
    }

    public ScenarioXmlWriter(Scenario model, boolean standalone) {
        super(model);
        this.standalone = standalone;
    }

    @Override
    public XmlNode getRootElement() {
        XmlNode rootXmlNode = new XmlNode(SCENARIO);
        this.addParameter(rootXmlNode, "name", ((Scenario)this.model).getName());
        this.addParameter(rootXmlNode, "orderNumber", ((Scenario)this.model).getOrderNumber());
        Map<Factor, Object> factorValues = ((Scenario)this.model).getFactorValues();
        for (Map.Entry<Factor, Object> entry : factorValues.entrySet()) {
            Object value = entry.getValue();
            XmlNode factorValueXmlNode = XmlNode.createElement(rootXmlNode, "factorValues", String.valueOf(value));
            Factor factor = entry.getKey();
            factorValueXmlNode.addAttribute("id", factor.getId());
            if (!this.standalone) continue;
            factorValueXmlNode.addAttribute("name", factor.getName());
        }
        this.addAllFeature(rootXmlNode, ((Scenario)this.model).getFeature());
        return rootXmlNode;
    }
}

