/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.model.parser;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import fr.reseaumexico.model.Factor;
import fr.reseaumexico.model.MexicoUtil;
import fr.reseaumexico.model.MexicoXmlConstant;
import fr.reseaumexico.model.Scenario;
import fr.reseaumexico.model.ScenarioImpl;
import fr.reseaumexico.model.ValueType;
import fr.reseaumexico.model.parser.MexicoXmlParser;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ScenarioXmlParser
extends MexicoXmlParser<Scenario> {
    protected final Map<String, Factor> factors;
    protected final Multimap<String, Factor> factorByName;
    protected final boolean standalone;
    protected final List<String> unknownFactors;

    public ScenarioXmlParser(Map<String, Factor> factors) {
        this(factors, true);
    }

    public ScenarioXmlParser(Map<String, Factor> factors, boolean standalone) {
        this.factors = factors;
        this.standalone = standalone;
        this.unknownFactors = Lists.newArrayList();
        this.factorByName = ArrayListMultimap.create();
        if (standalone) {
            this.factorByName.putAll((Multimap)Multimaps.index(factors.values(), MexicoUtil.GET_FACTOR_NAME));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Scenario parseModel(XmlPullParser parser) throws IOException, XmlPullParserException, ParseException {
        this.unknownFactors.clear();
        if (this.standalone) {
            this.checkStartFile(parser, MexicoXmlConstant.SCENARIO, "Scenario file must start with " + MexicoXmlConstant.SCENARIO + " tag");
        }
        ScenarioImpl scenario = new ScenarioImpl();
        String name = parser.getAttributeValue(null, "name");
        scenario.setName(name);
        String orderValue = parser.getAttributeValue(null, "orderNumber");
        scenario.setOrderNumber(Integer.parseInt(orderValue));
        if (this.testNextStartTag(parser, "factorValues")) {
            LinkedHashMap factorValues = Maps.newLinkedHashMap();
            while (!this.testCurrentEndTag(parser, MexicoXmlConstant.SCENARIO)) {
                String factorId = parser.getAttributeValue(null, "id");
                Factor factor = this.factors.get(factorId);
                if (factor == null) {
                    if (!this.standalone) throw new IOException("Could not find factor named '" + factorId + "' at line " + parser.getLineNumber());
                    String factorName = parser.getAttributeValue(null, "name");
                    Collection possibleFactors = this.factorByName.get((Object)factorName);
                    if (CollectionUtils.isNotEmpty((Collection)possibleFactors)) {
                        factor = (Factor)possibleFactors.iterator().next();
                    } else {
                        this.unknownFactors.add(factorName);
                        parser.nextText();
                        parser.nextTag();
                        continue;
                    }
                }
                ValueType valueType = factor.getDomain().getValueType();
                String value = parser.nextText();
                factorValues.put(factor, this.getTypedValue(valueType, value));
                parser.nextTag();
            }
            scenario.setFactorValues(factorValues);
        }
        if (!this.standalone) {
            parser.nextTag();
        }
        if (!this.standalone) return scenario;
        Set<Factor> usedFactors = scenario.getFactorValues().keySet();
        HashSet allFactors = Sets.newHashSet(this.factors.values());
        allFactors.removeAll(usedFactors);
        return scenario;
    }

    public List<String> getUnknownFactors() {
        return Lists.newArrayList(this.unknownFactors);
    }
}

