package fr.reseaumexico.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public abstract class DistributionParameter implements Serializable {

    private static final long serialVersionUID = 3834924162866231096L;

    public static final String PROPERTY_NAME = "name";

    public static final String PROPERTY_VALUE = "value";

    public static final String PROPERTY_VALUE_TYPE = "valueType";

    protected String name;

    protected Object value;

    protected ValueType valueType;

    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public String getName() {
        return name;
    }

    public void setName(String name) {
        String oldValue = getName();
        this.name = name;
        firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        Object oldValue = getValue();
        this.value = value;
        firePropertyChange(PROPERTY_VALUE, oldValue, value);
    }

    public ValueType getValueType() {
        return valueType;
    }

    public void setValueType(ValueType valueType) {
        ValueType oldValue = getValueType();
        this.valueType = valueType;
        firePropertyChange(PROPERTY_VALUE_TYPE, oldValue, valueType);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        firePropertyChange(propertyName, null, newValue);
    }

} //DistributionParameter
