/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.model.parser;

import com.google.common.collect.Maps;
import fr.reseaumexico.model.Factor;
import fr.reseaumexico.model.MexicoXmlConstant;
import fr.reseaumexico.model.Scenario;
import fr.reseaumexico.model.ScenarioImpl;
import fr.reseaumexico.model.ValueType;
import fr.reseaumexico.model.parser.MexicoXmlParser;
import java.io.IOException;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ScenarioXmlParser
extends MexicoXmlParser<Scenario> {
    protected final Map<String, Factor> factors;
    protected final boolean standalone;

    public ScenarioXmlParser(Map<String, Factor> factors) {
        this(factors, true);
    }

    public ScenarioXmlParser(Map<String, Factor> factors, boolean standalone) {
        this.factors = factors;
        this.standalone = standalone;
    }

    @Override
    protected Scenario parseModel(XmlPullParser parser) throws IOException, XmlPullParserException, ParseException {
        if (this.standalone) {
            this.checkStartFile(parser, MexicoXmlConstant.SCENARIO, "Scenario file must start with " + MexicoXmlConstant.SCENARIO + " tag");
        }
        ScenarioImpl scenario = new ScenarioImpl();
        String name = parser.getAttributeValue(null, "name");
        scenario.setName(name);
        String orderValue = parser.getAttributeValue(null, "orderNumber");
        scenario.setOrderNumber(Integer.parseInt(orderValue));
        if (this.testNextStartTag(parser, "factorValues")) {
            LinkedHashMap factorValues = Maps.newLinkedHashMap();
            while (!this.testCurrentEndTag(parser, MexicoXmlConstant.SCENARIO)) {
                String factorId = parser.getAttributeValue(null, MexicoXmlConstant.FACTOR);
                Factor factor = this.factors.get(factorId);
                if (factor == null) {
                    throw new IOException("Could not find factor named '" + factorId + "' at line " + parser.getLineNumber());
                }
                ValueType valueType = factor.getDomain().getValueType();
                String value = parser.nextText();
                factorValues.put(factor, this.getTypedValue(valueType, value));
                parser.nextTag();
            }
            scenario.setFactorValues(factorValues);
        }
        if (!this.standalone) {
            parser.nextTag();
        }
        return scenario;
    }
}

