/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.model;

import com.google.common.collect.Maps;
import fr.reseaumexico.model.Factor;
import fr.reseaumexico.model.Scenario;
import fr.reseaumexico.model.event.ScenarioFactorValueEvent;
import fr.reseaumexico.model.event.ScenarioFactorValueListener;
import java.util.Map;
import javax.swing.event.EventListenerList;

public class ScenarioImpl
extends Scenario {
    private static final long serialVersionUID = 1L;
    protected final EventListenerList factorListenerList = new EventListenerList();

    @Override
    public Object getFactorValue(Factor factor) {
        Map<Factor, Object> factorValues = this.getFactorValues();
        if (factorValues == null) {
            return null;
        }
        return factorValues.get(factor);
    }

    @Override
    public void setFactorValue(Factor factor, Object value) {
        Map<Factor, Object> oldFactorValues = this.getFactorValues();
        if (this.factorValues == null) {
            this.factorValues = Maps.newHashMap();
        }
        Object oldValue = this.factorValues.get(factor);
        this.factorValues.put(factor, value);
        this.firePropertyChange("factorValues", oldFactorValues, this.factorValues);
        this.fireFactorValueChanged(factor.getId(), oldValue, value);
    }

    @Override
    public void addFactorValueListener(ScenarioFactorValueListener factorListener) {
        this.factorListenerList.add(ScenarioFactorValueListener.class, factorListener);
    }

    @Override
    public void removeFactorValueListener(ScenarioFactorValueListener factorListener) {
        this.factorListenerList.remove(ScenarioFactorValueListener.class, factorListener);
    }

    protected void fireFactorValueChanged(String factorId, Object oldValue, Object newValue) {
        ScenarioFactorValueListener[] listeners;
        ScenarioFactorValueEvent event = new ScenarioFactorValueEvent(this, factorId, oldValue, newValue);
        for (ScenarioFactorValueListener listener : listeners = (ScenarioFactorValueListener[])this.factorListenerList.getListeners(ScenarioFactorValueListener.class)) {
            listener.factorValueChanged(event);
        }
    }

    public String toString() {
        return this.getName();
    }
}

