/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.model.writer;

import fr.reseaumexico.model.DistributionParameter;
import fr.reseaumexico.model.Domain;
import fr.reseaumexico.model.ExperimentDesign;
import fr.reseaumexico.model.Factor;
import fr.reseaumexico.model.Level;
import fr.reseaumexico.model.writer.MexicoXmlWriter;
import fr.reseaumexico.model.writer.XmlNode;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ExperimentDesignXmlWriter
extends MexicoXmlWriter<ExperimentDesign> {
    public ExperimentDesignXmlWriter(File file, ExperimentDesign model) throws IOException {
        super(file, model);
    }

    @Override
    public XmlNode getRootElement() {
        XmlNode rootXmlNode = new XmlNode(EXPERIMENT_DESIGN);
        this.composeExperimentDesignMeta(rootXmlNode);
        this.composeFactors(rootXmlNode);
        return rootXmlNode;
    }

    protected void composeExperimentDesignMeta(XmlNode rootXmlNode) {
        Date date = ((ExperimentDesign)this.model).getDate();
        this.addParameter(rootXmlNode, "date", this.formatDate(date));
        this.addParameter(rootXmlNode, "id", ((ExperimentDesign)this.model).getId());
        this.addParameter(rootXmlNode, "author", ((ExperimentDesign)this.model).getAuthor());
        this.addParameter(rootXmlNode, "licence", ((ExperimentDesign)this.model).getLicence());
        String description = ((ExperimentDesign)this.model).getDescription();
        if (StringUtils.isNotEmpty((CharSequence)description)) {
            XmlNode.createElement(rootXmlNode, "description", description);
        }
    }

    protected void composeFactors(XmlNode rootXmlNode) {
        Collection<Factor> factors = ((ExperimentDesign)this.model).getFactor();
        if (factors.isEmpty()) {
            return;
        }
        XmlNode factorsXmlNode = XmlNode.createElement(rootXmlNode, "factors");
        for (Factor factor : factors) {
            Domain domain;
            XmlNode factorXmlNode = XmlNode.createElement(factorsXmlNode, FACTOR);
            this.addParameter(factorXmlNode, "id", factor.getId());
            this.addParameter(factorXmlNode, "name", factor.getName());
            this.addParameter(factorXmlNode, "unit", factor.getUnit());
            String description = ((ExperimentDesign)this.model).getDescription();
            if (StringUtils.isNotEmpty((CharSequence)description)) {
                XmlNode.createElement(factorXmlNode, "description", factor.getDescription());
            }
            if ((domain = factor.getDomain()) != null) {
                Collection<Level> levels;
                XmlNode domainXmlNode = XmlNode.createElement(factorXmlNode, "domain");
                this.addParameter(domainXmlNode, "name", domain.getName());
                this.addParameter(domainXmlNode, "valueType", (Object)domain.getValueType());
                this.addParameter(domainXmlNode, "nominalValue", domain.getNominalValue());
                this.addParameter(domainXmlNode, "distributionName", domain.getDistributionName());
                Collection<DistributionParameter> distributionParameters = domain.getDistributionParameter();
                if (distributionParameters != null) {
                    for (DistributionParameter distributionParameter : distributionParameters) {
                        XmlNode distributionParameterXmlNode = XmlNode.createElement(domainXmlNode, DOMAIN_DISTRIBUTION_PARAMETER);
                        this.addParameter(distributionParameterXmlNode, "name", distributionParameter.getName());
                        this.addParameter(distributionParameterXmlNode, "value", distributionParameter.getValue());
                        this.addParameter(distributionParameterXmlNode, "valueType", (Object)distributionParameter.getValueType());
                    }
                }
                if ((levels = domain.getLevels()) != null) {
                    for (Level level : levels) {
                        XmlNode distributionParameterXmlNode = XmlNode.createElement(domainXmlNode, DOMAIN_LEVEL);
                        this.addParameter(distributionParameterXmlNode, "value", level.getValue());
                        this.addParameter(distributionParameterXmlNode, "weight", level.getWeight());
                    }
                }
            }
            this.addAllFeature(factorXmlNode, factor.getFeature());
        }
    }
}

