/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.model.parser;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.reseaumexico.model.ExperimentDesign;
import fr.reseaumexico.model.Factor;
import fr.reseaumexico.model.InputDesign;
import fr.reseaumexico.model.InputDesignImpl;
import fr.reseaumexico.model.MexicoTechnicalException;
import fr.reseaumexico.model.MexicoXmlConstant;
import fr.reseaumexico.model.Scenario;
import fr.reseaumexico.model.ScenarioImpl;
import fr.reseaumexico.model.ValueType;
import fr.reseaumexico.model.parser.ExperimentDesignParser;
import fr.reseaumexico.model.parser.MexicoXmlParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class InputDesignParser
extends MexicoXmlParser<InputDesign> {
    protected ExperimentDesignParser experimentDesignParser;

    public InputDesignParser(File file) throws FileNotFoundException {
        super(file);
        this.experimentDesignParser = new ExperimentDesignParser(file);
    }

    @Override
    protected InputDesign parseModel(XmlPullParser parser) throws IOException, XmlPullParserException, ParseException {
        InputDesignImpl model = new InputDesignImpl();
        this.parseInputDesignMeta(parser, model);
        ExperimentDesign experimentDesign = this.experimentDesignParser.parseModel(parser);
        model.setExperimentDesign(experimentDesign);
        this.parseScenarios(parser, model);
        return model;
    }

    protected void parseInputDesignMeta(XmlPullParser parser, InputDesign model) throws IOException, XmlPullParserException, ParseException {
        if (parser.next() == 2 && !this.parserEqual(parser, MexicoXmlConstant.INPUT_DESIGN)) {
            throw new MexicoTechnicalException("Input design file must start with " + MexicoXmlConstant.INPUT_DESIGN + " tag");
        }
        String dateAsString = parser.getAttributeValue(null, "date");
        model.setDate(this.parseDate(dateAsString));
    }

    protected void parseScenarios(XmlPullParser parser, InputDesign model) throws IOException, XmlPullParserException {
        if (parser.nextTag() == 2 && this.parserEqual(parser, MexicoXmlConstant.SCENARIO)) {
            ArrayList scenarios = Lists.newArrayList();
            while (parser.getEventType() != 3 || !this.parserEqual(parser, MexicoXmlConstant.INPUT_DESIGN)) {
                scenarios.add(this.parseScenario(parser));
            }
            model.setScenario(scenarios);
        }
    }

    protected Scenario parseScenario(XmlPullParser parser) throws IOException, XmlPullParserException {
        ScenarioImpl scenario = new ScenarioImpl();
        String name = parser.getAttributeValue(null, "name");
        scenario.setName(name);
        String orderValue = parser.getAttributeValue(null, "orderNumber");
        scenario.setOrderNumber(Integer.parseInt(orderValue));
        if (parser.nextTag() == 2 && this.parserEqual(parser, "factorValues")) {
            LinkedHashMap factorValues = Maps.newLinkedHashMap();
            while (parser.getEventType() != 3 || !this.parserEqual(parser, MexicoXmlConstant.SCENARIO)) {
                String factorId = parser.getAttributeValue(null, MexicoXmlConstant.FACTOR);
                Factor factor = this.experimentDesignParser.getFactors().get(factorId);
                ValueType valueType = factor.getDomain().getValueType();
                String value = parser.nextText();
                factorValues.put(factor, this.getTypedValue(valueType, value));
                parser.nextTag();
            }
            scenario.setFactorValues(factorValues);
        }
        parser.nextTag();
        return scenario;
    }
}

