/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.model;

import fr.reseaumexico.model.ExperimentDesign;
import fr.reseaumexico.model.Scenario;
import fr.reseaumexico.model.event.InputDesignFactorListener;
import fr.reseaumexico.model.event.InputDesignScenarioListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

public abstract class InputDesign
implements Serializable {
    private static final long serialVersionUID = 3486691221034055733L;
    public static final String PROPERTY_DATE = "date";
    public static final String PROPERTY_EXPERIMENT_DESIGN = "experimentDesign";
    public static final String PROPERTY_SCENARIO = "scenario";
    protected Date date;
    protected ExperimentDesign experimentDesign;
    protected Collection<Scenario> scenario;
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        Date oldValue = this.getDate();
        this.date = date;
        this.firePropertyChange(PROPERTY_DATE, oldValue, date);
    }

    public ExperimentDesign getExperimentDesign() {
        return this.experimentDesign;
    }

    public void setExperimentDesign(ExperimentDesign experimentDesign) {
        ExperimentDesign oldValue = this.getExperimentDesign();
        this.experimentDesign = experimentDesign;
        this.firePropertyChange(PROPERTY_EXPERIMENT_DESIGN, oldValue, experimentDesign);
    }

    public Scenario getScenario(int index) {
        Scenario o = this.getChild(this.scenario, index);
        return o;
    }

    public void addScenario(Scenario scenario) {
        this.getScenario().add(scenario);
        this.firePropertyChange(PROPERTY_SCENARIO, null, scenario);
    }

    public void addAllScenario(Collection<Scenario> scenario) {
        this.getScenario().addAll(scenario);
        this.firePropertyChange(PROPERTY_SCENARIO, null, scenario);
    }

    public boolean removeScenario(Scenario scenario) {
        boolean removed = this.getScenario().remove(scenario);
        if (removed) {
            this.firePropertyChange(PROPERTY_SCENARIO, scenario, null);
        }
        return removed;
    }

    public boolean removeAllScenario(Collection<Scenario> scenario) {
        boolean removed = this.getScenario().removeAll(scenario);
        if (removed) {
            this.firePropertyChange(PROPERTY_SCENARIO, scenario, null);
        }
        return removed;
    }

    public boolean containsScenario(Scenario scenario) {
        boolean contains = this.getScenario().contains(scenario);
        return contains;
    }

    public boolean containsAllScenario(Collection<Scenario> scenario) {
        boolean contains = this.getScenario().containsAll(scenario);
        return contains;
    }

    public Collection<Scenario> getScenario() {
        return this.scenario;
    }

    public void setScenario(Collection<Scenario> scenario) {
        Collection<Scenario> oldValue = this.getScenario();
        this.scenario = scenario;
        this.firePropertyChange(PROPERTY_SCENARIO, oldValue, scenario);
    }

    public abstract void addInputDesignScenarioListener(InputDesignScenarioListener var1);

    public abstract void removeInputDesignScenarioListener(InputDesignScenarioListener var1);

    public abstract void addInputDesignFactorListener(InputDesignFactorListener var1);

    public abstract void removeInputDesignFactorListener(InputDesignFactorListener var1);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        this.firePropertyChange(propertyName, null, newValue);
    }

    protected <T> T getChild(Collection<T> childs, int index) {
        if (childs != null) {
            int i = 0;
            for (T o : childs) {
                if (index == i) {
                    return o;
                }
                ++i;
            }
        }
        return null;
    }
}

