package fr.reseaumexico.model;

import fr.reseaumexico.model.event.InputDesignFactorListener;
import fr.reseaumexico.model.event.InputDesignScenarioListener;
import java.util.Collection;
import java.util.Date;

public abstract class InputDesign extends AbstractMexicoBean {

    private static final long serialVersionUID = 3486691221034055733L;

    public static final String PROPERTY_DATE = "date";

    public static final String PROPERTY_EXPERIMENT_DESIGN = "experimentDesign";

    public static final String PROPERTY_SCENARIO = "scenario";

    protected Date date;

    protected ExperimentDesign experimentDesign;

    protected Collection<Scenario> scenario;

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        Date oldValue = getDate();
        this.date = date;
        firePropertyChange(PROPERTY_DATE, oldValue, date);
    }

    public ExperimentDesign getExperimentDesign() {
        return experimentDesign;
    }

    public void setExperimentDesign(ExperimentDesign experimentDesign) {
        ExperimentDesign oldValue = getExperimentDesign();
        this.experimentDesign = experimentDesign;
        firePropertyChange(PROPERTY_EXPERIMENT_DESIGN, oldValue, experimentDesign);
    }

    public Scenario getScenario(int index) {
        Scenario o = getChild(scenario, index);
        return o;
    }

    public boolean isScenarioEmpty() {
        return scenario == null || scenario.isEmpty();
    }

    public int sizeScenario() {
        return scenario == null ? 0 : scenario.size();
    }

    public void addScenario(Scenario scenario) {
        getScenario().add(scenario);
        firePropertyChange(PROPERTY_SCENARIO, null, scenario);
    }

    public void addAllScenario(Collection<Scenario> scenario) {
        getScenario().addAll(scenario);
        firePropertyChange(PROPERTY_SCENARIO, null, scenario);
    }

    public boolean removeScenario(Scenario scenario) {
        boolean removed = getScenario().remove(scenario);
        if (removed) {
            firePropertyChange(PROPERTY_SCENARIO, scenario, null);
        }
        return removed;
    }

    public boolean removeAllScenario(Collection<Scenario> scenario) {
        boolean  removed = getScenario().removeAll(scenario);
        if (removed) {
            firePropertyChange(PROPERTY_SCENARIO, scenario, null);
        }
        return removed;
    }

    public boolean containsScenario(Scenario scenario) {
        boolean contains = getScenario().contains(scenario);
        return contains;
    }

    public boolean containsAllScenario(Collection<Scenario> scenario) {
        boolean  contains = getScenario().containsAll(scenario);
        return contains;
    }

    public Collection<Scenario> getScenario() {
        return scenario;
    }

    public void setScenario(Collection<Scenario> scenario) {
        Collection<Scenario> oldValue = getScenario();
        this.scenario = scenario;
        firePropertyChange(PROPERTY_SCENARIO, oldValue, scenario);
    }

    public abstract void addInputDesignScenarioListener(InputDesignScenarioListener scenarioListener);

    public abstract void removeInputDesignScenarioListener(InputDesignScenarioListener scenarioListener);

    public abstract void addInputDesignFactorListener(InputDesignFactorListener factorListener);

    public abstract void removeInputDesignFactorListener(InputDesignFactorListener factorListener);

    public abstract void renameScenario(Scenario scenario, String newName);

} //InputDesign
