package fr.reseaumexico.model;

/*
 * #%L
 * JMexico :: Model
 * $Id: AbstractMexicoBean.java 108 2012-11-13 13:32:27Z tchemit $
 * $HeadURL: https://svn.codelutin.com/jmexico/tags/jmexico-0.11/jmexico-model/src/main/java/fr/reseaumexico/model/AbstractMexicoBean.java $
 * %%
 * Copyright (C) 2011 - 2012 Réseau Mexico, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.util.CollectionUtil;

import java.util.Collection;
import java.util.List;

/**
 * Abstract bean class.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.8
 */
public abstract class AbstractMexicoBean extends AbstractSerializableBean {

    private static final long serialVersionUID = 1L;

    protected <T> T getChild(Collection<T> list, int index) {
        return CollectionUtil.getOrNull(list, index);
    }

    protected <T> T getChild(List<T> list, int index) {
        return CollectionUtil.getOrNull(list, index);
    }
}
