/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.model.writer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class XmlNode {
    public static final String XML_META = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String CLOSED_TAG = "%s<%s%s/>\n";
    public static final String START_TAG = "%s<%s%s>";
    public static final String END_TAG = "%s</%s>\n";
    protected LinkedList<XmlNode> children;
    protected Map<String, String> attributes;
    protected String tagName;
    protected String text;

    public XmlNode(String tagName) {
        this(tagName, null);
    }

    public XmlNode(String tagName, String text) {
        this.tagName = tagName;
        this.text = text;
        this.children = Lists.newLinkedList();
        this.attributes = Maps.newHashMap();
    }

    public void add(XmlNode e) {
        this.children.add(e);
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public String toXml(int indent) {
        StringBuilder stringBuilder = new StringBuilder(XML_META).append("\n");
        this.buildXml(-indent, indent, stringBuilder);
        return stringBuilder.toString();
    }

    protected void buildXml(int start, int indent, StringBuilder stringBuilder) {
        if (this.children.isEmpty() && StringUtils.isEmpty((CharSequence)this.text)) {
            this.addToBuilder(stringBuilder, CLOSED_TAG, this.getIndentPrefix(start, indent), this.tagName);
            return;
        }
        this.addToBuilder(stringBuilder, START_TAG, this.getIndentPrefix(start, indent), this.tagName);
        if (StringUtils.isNotEmpty((CharSequence)this.text)) {
            this.addToBuilder(stringBuilder, END_TAG, StringEscapeUtils.escapeXml((String)this.text), this.tagName);
        } else {
            stringBuilder.append("\n");
            for (XmlNode child : this.children) {
                child.buildXml(start + indent, indent, stringBuilder);
            }
            this.addToBuilder(stringBuilder, END_TAG, this.getIndentPrefix(start, indent), this.tagName);
        }
    }

    protected void addToBuilder(StringBuilder stringBuilder, String template, String prefix, String tagName) {
        stringBuilder.append(String.format(template, prefix, tagName, this.getAttributesAsString()));
    }

    protected String getIndentPrefix(int start, int lenght) {
        String result = "";
        for (int i = 0; i < start + lenght; ++i) {
            result = result + " ";
        }
        return result;
    }

    protected String getAttributesAsString() {
        StringBuilder builder = new StringBuilder();
        Set<Map.Entry<String, String>> entries = this.attributes.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            builder.append(" ").append(entry.getKey()).append("=\"").append(StringEscapeUtils.escapeXml((String)entry.getValue())).append("\"");
        }
        return builder.toString();
    }

    public static XmlNode createElement(XmlNode parentXmlNode, String tagName) {
        return XmlNode.createElement(parentXmlNode, tagName, null);
    }

    public static XmlNode createElement(XmlNode parentXmlNode, String tagName, String text) {
        XmlNode xmlNode = XmlNode.createElement(tagName, text);
        parentXmlNode.add(xmlNode);
        return xmlNode;
    }

    public static XmlNode createElement(String tagName, String text) {
        return new XmlNode(tagName, text);
    }
}

