/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.model.writer;

import fr.reseaumexico.model.DateFormatFactory;
import fr.reseaumexico.model.Feature;
import fr.reseaumexico.model.MexicoXmlConstant;
import fr.reseaumexico.model.writer.XmlNode;
import fr.reseaumexico.model.writer.XmlWriter;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;

public abstract class MexicoXmlWriter<M>
extends XmlWriter<M>
implements MexicoXmlConstant {
    protected MexicoXmlWriter(File file, M model) throws IOException {
        super(file, model);
    }

    public void addParameter(XmlNode xmlNode, String parameterName, Object value) {
        if (value != null) {
            xmlNode.addAttribute(parameterName, value.toString());
        }
    }

    protected void addAllFeature(XmlNode factorXmlNode, Collection<Feature> features) {
        if (features != null) {
            for (Feature feature : features) {
                XmlNode featureXmlNode = XmlNode.createElement(factorXmlNode, FEATURE);
                this.addParameter(featureXmlNode, "name", feature.getName());
                this.addParameter(featureXmlNode, "value", feature.getValue());
                this.addParameter(featureXmlNode, "valueType", (Object)feature.getValueType());
            }
        }
    }

    public String formatDate(Date toFormat) {
        return DateFormatFactory.getMexicoDateFormat().format(toFormat);
    }
}

