/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.model.writer;

import fr.reseaumexico.model.Factor;
import fr.reseaumexico.model.InputDesign;
import fr.reseaumexico.model.Scenario;
import fr.reseaumexico.model.writer.ExperimentDesignXmlWriter;
import fr.reseaumexico.model.writer.MexicoXmlWriter;
import fr.reseaumexico.model.writer.XmlNode;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public class InputDesignXmlWriter
extends MexicoXmlWriter<InputDesign> {
    protected ExperimentDesignXmlWriter experimentDesignXmlWriter;

    public InputDesignXmlWriter(File file, InputDesign model) throws IOException {
        super(file, model);
        this.experimentDesignXmlWriter = new ExperimentDesignXmlWriter(file, model.getExperimentDesign());
    }

    @Override
    public XmlNode getRootElement() {
        XmlNode rootXmlNode = new XmlNode(INPUT_DESIGN);
        this.composeInputDesignMeta(rootXmlNode);
        this.composeScenarios(rootXmlNode);
        return rootXmlNode;
    }

    protected void composeInputDesignMeta(XmlNode rootXmlNode) {
        Date date = ((InputDesign)this.model).getDate();
        this.addParameter(rootXmlNode, "date", this.formatDate(date));
        rootXmlNode.add(this.experimentDesignXmlWriter.getRootElement());
    }

    protected void composeScenarios(XmlNode rootXmlNode) {
        for (Scenario scenario : ((InputDesign)this.model).getScenario()) {
            XmlNode scenariosXmlNode = XmlNode.createElement(rootXmlNode, SCENARIO);
            this.addParameter(scenariosXmlNode, "name", scenario.getName());
            this.addParameter(scenariosXmlNode, "orderNumber", scenario.getOrderNumber());
            Map<Factor, Object> factorValues = scenario.getFactorValues();
            for (Map.Entry<Factor, Object> entry : factorValues.entrySet()) {
                Object value = entry.getValue();
                XmlNode factorValueXmlNode = XmlNode.createElement(scenariosXmlNode, "factorValues", String.valueOf(value));
                factorValueXmlNode.addAttribute(FACTOR, entry.getKey().getId());
            }
            this.addAllFeature(scenariosXmlNode, scenario.getFeature());
        }
    }
}

