/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.model.parser;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.reseaumexico.model.DistributionParameterImpl;
import fr.reseaumexico.model.Domain;
import fr.reseaumexico.model.DomainImpl;
import fr.reseaumexico.model.ExperimentDesign;
import fr.reseaumexico.model.ExperimentDesignImpl;
import fr.reseaumexico.model.Factor;
import fr.reseaumexico.model.FactorImpl;
import fr.reseaumexico.model.Feature;
import fr.reseaumexico.model.FeatureImpl;
import fr.reseaumexico.model.LevelImpl;
import fr.reseaumexico.model.MexicoTechnicalException;
import fr.reseaumexico.model.MexicoXmlConstant;
import fr.reseaumexico.model.ValueType;
import fr.reseaumexico.model.parser.MexicoXmlParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ExperimentDesignParser
extends MexicoXmlParser<ExperimentDesign>
implements MexicoXmlConstant {
    protected Map<String, Factor> factors = Maps.newHashMap();

    public ExperimentDesignParser(File file) throws FileNotFoundException {
        super(file);
    }

    @Override
    protected ExperimentDesign parseModel(XmlPullParser parser) throws IOException, XmlPullParserException, ParseException {
        ExperimentDesignImpl model = new ExperimentDesignImpl();
        this.parseExperimentDesignMeta(parser, model);
        this.parseFactors(parser, model);
        return model;
    }

    protected void parseExperimentDesignMeta(XmlPullParser parser, ExperimentDesign model) throws IOException, XmlPullParserException, ParseException {
        if (parser.nextTag() == 2 && !this.parserEqual(parser, EXPERIMENT_DESIGN)) {
            throw new MexicoTechnicalException("Experiment design file must start with " + EXPERIMENT_DESIGN + " tag");
        }
        String id = parser.getAttributeValue(null, "id");
        model.setId(id);
        String dateAsString = parser.getAttributeValue(null, "date");
        model.setDate(this.parseDate(dateAsString));
        String author = parser.getAttributeValue(null, "author");
        model.setAuthor(author);
        String license = parser.getAttributeValue(null, "licence");
        model.setLicence(license);
        if (parser.nextTag() == 2 && this.parserEqual(parser, "description")) {
            model.setDescription(parser.nextText());
            parser.nextTag();
        }
    }

    protected void parseFactors(XmlPullParser parser, ExperimentDesign model) throws IOException, XmlPullParserException {
        int eventType = parser.getEventType();
        if (eventType == 2 && this.parserEqual(parser, "factors")) {
            ArrayList factors = Lists.newArrayList();
            while (parser.nextTag() != 3 || !this.parserEqual(parser, "factors")) {
                factors.add(this.parseFactor(parser));
            }
            model.setFactor(factors);
        }
        parser.nextTag();
    }

    protected Factor parseFactor(XmlPullParser parser) throws IOException, XmlPullParserException {
        FactorImpl factor = new FactorImpl();
        String id = parser.getAttributeValue(null, "id");
        factor.setId(id);
        while (parser.getEventType() != 3 || !this.parserEqual(parser, FACTOR)) {
            int eventType = parser.nextTag();
            if (eventType == 2 && this.parserEqual(parser, "description")) {
                factor.setDescription(parser.nextText());
                eventType = parser.nextTag();
            }
            if (eventType == 2 && this.parserEqual(parser, "domain")) {
                factor.setDomain(this.parseDomain(parser));
            }
            if (parser.getEventType() != 2 || !this.parserEqual(parser, FEATURE)) continue;
            LinkedList features = Lists.newLinkedList();
            while (this.parserEqual(parser, FEATURE)) {
                features.add(this.parseFeature(parser));
                parser.nextTag();
                parser.nextTag();
            }
            factor.setFeature(features);
        }
        this.factors.put(factor.getId(), factor);
        return factor;
    }

    protected Domain parseDomain(XmlPullParser parser) throws XmlPullParserException, IOException {
        DomainImpl domain = new DomainImpl();
        String domaineName = parser.getAttributeValue(null, "name");
        domain.setName(domaineName);
        String distributionName = parser.getAttributeValue(null, "distributionName");
        domain.setDistributionName(distributionName);
        String domaineValueType = parser.getAttributeValue(null, "valueType");
        ValueType domaineType = ValueType.valueOf(domaineValueType);
        domain.setValueType(domaineType);
        String nominaleValue = parser.getAttributeValue(null, "nominalValue");
        domain.setNominalValue(this.getTypedValue(domaineType, nominaleValue));
        while (parser.getEventType() != 3 || !this.parserEqual(parser, "domain")) {
            int eventType = parser.nextTag();
            if (eventType == 2 && this.parserEqual(parser, DOMAIN_DISTRIBUTION_PARAMETER)) {
                ArrayList distributionParameters = Lists.newArrayList();
                while (this.parserEqual(parser, DOMAIN_DISTRIBUTION_PARAMETER)) {
                    DistributionParameterImpl distributionParameter = new DistributionParameterImpl();
                    String name = parser.getAttributeValue(null, "name");
                    distributionParameter.setName(name);
                    String valueType = parser.getAttributeValue(null, "valueType");
                    ValueType type = ValueType.valueOf(valueType);
                    distributionParameter.setValueType(type);
                    String value = parser.getAttributeValue(null, "value");
                    distributionParameter.setValue(this.getTypedValue(type, value));
                    distributionParameters.add(distributionParameter);
                    parser.nextTag();
                    eventType = parser.nextTag();
                }
                domain.setDistributionParameter(distributionParameters);
            }
            if (eventType != 2 || !this.parserEqual(parser, DOMAIN_LEVEL)) continue;
            ArrayList levels = Lists.newArrayList();
            while (this.parserEqual(parser, DOMAIN_LEVEL)) {
                LevelImpl level = new LevelImpl();
                String value = parser.getAttributeValue(null, "value");
                level.setValue(value);
                String weight = parser.getAttributeValue(null, "weight");
                level.setWeight(Integer.valueOf(weight));
                levels.add(level);
            }
            domain.setLevels(levels);
        }
        return domain;
    }

    protected Feature parseFeature(XmlPullParser parser) {
        FeatureImpl feature = new FeatureImpl();
        String name = parser.getAttributeValue(null, "name");
        feature.setName(name);
        String valueType = parser.getAttributeValue(null, "valueType");
        ValueType type = ValueType.valueOf(valueType);
        feature.setValueType(type);
        String value = parser.getAttributeValue(null, "value");
        feature.setValue(this.getTypedValue(type, value));
        return feature;
    }

    public Map<String, Factor> getFactors() {
        return this.factors;
    }
}

