/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.editor;

import com.google.common.collect.Maps;
import fr.reseaumexico.editor.InputDesignEditor;
import fr.reseaumexico.model.Factor;
import fr.reseaumexico.model.InputDesign;
import fr.reseaumexico.model.Scenario;
import fr.reseaumexico.model.ScenarioImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;

public class InputDesignEditorHandler {
    public void addScenario(InputDesignEditor editor) {
        InputDesign inputDesign = editor.getInputDesign();
        String selectedName = JOptionPane.showInputDialog(editor, I18n._((String)"jmexico.scenario.inputName", (Object[])new Object[0]), I18n._((String)"jmexico.scenario.inputName.title", (Object[])new Object[0]), 3);
        if (StringUtils.isNotBlank((CharSequence)selectedName)) {
            Collection scenarios = inputDesign.getScenario();
            int maxOrder = 0;
            if (scenarios != null) {
                for (Scenario scenario : scenarios) {
                    if (selectedName.equalsIgnoreCase(scenario.getName())) {
                        JOptionPane.showMessageDialog(editor, I18n._((String)"jmexico.error.title", (Object[])new Object[0]), I18n._((String)"jmexico.error.scenario.name.used", (Object[])new Object[0]), 0);
                        return;
                    }
                    int orderNumber = scenario.getOrderNumber();
                    if (maxOrder >= orderNumber) continue;
                    maxOrder = orderNumber;
                }
            }
            ScenarioImpl scenarioToAdd = new ScenarioImpl();
            scenarioToAdd.setOrderNumber(maxOrder + 1);
            scenarioToAdd.setName(selectedName);
            Collection factors = inputDesign.getExperimentDesign().getFactor();
            HashMap factorValues = Maps.newHashMap();
            for (Factor factor : factors) {
                factorValues.put(factor, null);
            }
            scenarioToAdd.setFactorValues((Map)factorValues);
            inputDesign.addScenario((Scenario)scenarioToAdd);
        }
    }

    public void removeScenario(InputDesignEditor editor) {
        InputDesign inputDesign = editor.getInputDesign();
        Collection scenarios = inputDesign.getScenario();
        Scenario scenario = (Scenario)JOptionPane.showInputDialog(editor, I18n._((String)"jmexico.scenario.selectRemove", (Object[])new Object[0]), I18n._((String)"jmexico.scenario.selectRemove.title", (Object[])new Object[0]), -1, null, scenarios.toArray(), null);
        if (scenario != null) {
            inputDesign.removeScenario(scenario);
        }
    }
}

