package fr.reseaumexico.editor;

/*
 * #%L
 * JMexico :: Swing Editor
 * %%
 * Copyright (C) 2011 - 2014 Réseau Mexico, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import fr.reseaumexico.model.InputDesign;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n._;

public class InputDesignEditor extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_SCENARIO_BUTTON_ENABLED = "addScenarioButton.enabled";
    public static final String BINDING_CLONE_SCENARIO_BUTTON_ENABLED = "cloneScenarioButton.enabled";
    public static final String BINDING_EXPORT_SCENARIO_BUTTON_ENABLED = "exportScenarioButton.enabled";
    public static final String BINDING_IMPORT_SCENARIO_BUTTON_ENABLED = "importScenarioButton.enabled";
    public static final String BINDING_INPUT_DESIGN_TABLE_MODEL = "inputDesignTable.model";
    public static final String BINDING_REMOVE_SCENARIO_BUTTON_ENABLED = "removeScenarioButton.enabled";
    public static final String BINDING_RENAME_SCENARIO_BUTTON_ENABLED = "renameScenarioButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAL1Wy24TMRS9SUlLyqsPKOVRlAISZcEE2KHyLlQtKg8RhBDZ4GZM4sqxB9tDByEQn8AnwJ4NEjtWiAVrFmwQv4AQC7aIa0+SyWNIigREymQ0Pvfe4+t7TubVV8hpBbNrJIo8FQrD6tS7cuHOneura7RiLlFdUSwwUkH8yWQhW4Ytfuu5NnCovGLDi43w4oKsB1JQ0RY9vwKj2jziVNcoNQZmOiMqWhdLreX5KAhVM2uLVFrWF9+/ZZ/7z15mAaIA2W3FrRQGRSU72bQCWeYbmMBKD0mRE1FFGoqJKvLdZp8tcKL1NVKnD+ApjKzAcEAUJjNwcONbdjlcfBQYGGciCC2MVcVlnyHQwNx95SmqKQnrNGIV6VG34C13Q4PAJRo2MFIjwucUg4sbDV6KI5Icubr0KTdwbKMZrlp8Er/t8JVSRUnObxBBjxvYbTsWeXodG+i1LVl4vhU11taAW2SVUwNHBhNwSJthIikfo25JyS8SbMRER3lbmHdWHie+X6pQQRSTF0NjpDAw2REUP7Xw6VbUTjxwHIDOQLs204Ory4eDcZMVjpMyOB3DiVJmMI5G/XEK9nUoArXmJVpLxJApQ06F+NjAdLlXnjdxKRbmdJcwbUK3+nNq8tPbL28Wm2rMY+1dqdA2M0GVBEoGOMnMlt4RSzE0jBevkmC+jFkoRydyTrM/hVipsYzksN64DfdsuLdEdA1T5EY+v3s/de/jEGQXYZRL4i8Si1+GvKnh1NUk96Pg3HnHaOv6ZryO4Xco0cfux+7Gq1LjxtDJYO7oE2x+RfKwLhZwknDYbzPN3DxvMirEn7yS60uUVWvoF9mTxyPs3f6U3rU2sJr/8GOy9Pp8s38Z3M+e38KTHubuwjATnAnq/KxhVan+tSXQNPRlYklpJgUpIg0asj/mrid62pVFS8IJRCT6aSFpWJuE544WZs8URMj5E9siGmFb9q01FI9HwqTwUKGeboxyFNpSp1wj7N08pEn4HxE70EUsNoG+3FKN4o/o7W3QY7qZ5HLEtNFu1n5LzLrOIGK9zvTXic10EXM215dXmhP+p+OMzbV/19IM+J8fZ+zm/YmlOf4gYhmDL0fOOai/bGgdzytpXqmx0EyJBNMKT+kuXPOlZGDpYU4eSeQJ20/7xJDCKhM+/uGe7amSsddRzPgL5KBQkpgKAAA=";
    private static final Log log = LogFactory.getLog(InputDesignEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addScenarioButton;
    protected JButton cloneScenarioButton;
    protected JPanel editorToolBar;
    protected JButton exportScenarioButton;
    protected InputDesignEditorHandler handler;
    protected JButton importScenarioButton;
    protected InputDesignEditor inputDesignEditor = this;
    protected InputDesignTable inputDesignTable;
    protected InputDesignEditorModel model;
    protected JButton removeScenarioButton;
    protected JButton renameScenarioButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private void $afterCompleteSetup() {
        getHandler().initUI();
    }
    
    public void setInputDesign(InputDesign inputDesign) {
        getModel().setInputDesign(inputDesign);
    }
    
    public InputDesign getInputDesign() {
        return getModel().getInputDesign();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public InputDesignEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public InputDesignEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public InputDesignEditor() {
        $initialize();
    }

    public InputDesignEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public InputDesignEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public InputDesignEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public InputDesignEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public InputDesignEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addScenarioButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addScenario();
    }

    public void doActionPerformed__on__cloneScenarioButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().cloneScenario();
    }

    public void doActionPerformed__on__exportScenarioButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().exportScenario();
    }

    public void doActionPerformed__on__importScenarioButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().importScenario();
    }

    public void doActionPerformed__on__removeScenarioButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().removeScenario();
    }

    public void doActionPerformed__on__renameScenarioButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().renameScenario();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddScenarioButton() {
        return addScenarioButton;
    }

    public JButton getCloneScenarioButton() {
        return cloneScenarioButton;
    }

    public JPanel getEditorToolBar() {
        return editorToolBar;
    }

    public JButton getExportScenarioButton() {
        return exportScenarioButton;
    }

    public InputDesignEditorHandler getHandler() {
        return handler;
    }

    public JButton getImportScenarioButton() {
        return importScenarioButton;
    }

    public InputDesignTable getInputDesignTable() {
        return inputDesignTable;
    }

    public InputDesignEditorModel getModel() {
        return model;
    }

    public JButton getRemoveScenarioButton() {
        return removeScenarioButton;
    }

    public JButton getRenameScenarioButton() {
        return renameScenarioButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        editorToolBar.add(addScenarioButton, BorderLayout.WEST);
        editorToolBar.add(renameScenarioButton, BorderLayout.WEST);
        editorToolBar.add(removeScenarioButton, BorderLayout.EAST);
        editorToolBar.add(cloneScenarioButton, BorderLayout.EAST);
        editorToolBar.add(importScenarioButton, BorderLayout.EAST);
        editorToolBar.add(exportScenarioButton, BorderLayout.EAST);
    }

    protected void addChildrenToInputDesignEditor() {
        if (!allComponentsCreated) {
            return;
        }
        add($JScrollPane0, BorderLayout.CENTER);
        add(editorToolBar, BorderLayout.SOUTH);
    }

    protected void createAddScenarioButton() {
        $objectMap.put("addScenarioButton", addScenarioButton = new JButton());
        
        addScenarioButton.setName("addScenarioButton");
        addScenarioButton.setText(_("jmexico.action.add.scenario"));
        addScenarioButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addScenarioButton"));
    }

    protected void createCloneScenarioButton() {
        $objectMap.put("cloneScenarioButton", cloneScenarioButton = new JButton());
        
        cloneScenarioButton.setName("cloneScenarioButton");
        cloneScenarioButton.setText(_("jmexico.action.clone.scenario"));
        cloneScenarioButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cloneScenarioButton"));
    }

    protected void createEditorToolBar() {
        $objectMap.put("editorToolBar", editorToolBar = new JPanel());
        
        editorToolBar.setName("editorToolBar");
    }

    protected void createExportScenarioButton() {
        $objectMap.put("exportScenarioButton", exportScenarioButton = new JButton());
        
        exportScenarioButton.setName("exportScenarioButton");
        exportScenarioButton.setText(_("jmexico.action.export.scenario"));
        exportScenarioButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__exportScenarioButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new InputDesignEditorHandler(this));
    }

    protected void createImportScenarioButton() {
        $objectMap.put("importScenarioButton", importScenarioButton = new JButton());
        
        importScenarioButton.setName("importScenarioButton");
        importScenarioButton.setText(_("jmexico.action.import.scenario"));
        importScenarioButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importScenarioButton"));
    }

    protected void createInputDesignTable() {
        $objectMap.put("inputDesignTable", inputDesignTable = new InputDesignTable());
        
        inputDesignTable.setName("inputDesignTable");
        inputDesignTable.setColumnControlVisible(true);
        inputDesignTable.setRowHeight(20);
    }

    protected void createModel() {
        $objectMap.put("model", model = new InputDesignEditorModel());
    }

    protected void createRemoveScenarioButton() {
        $objectMap.put("removeScenarioButton", removeScenarioButton = new JButton());
        
        removeScenarioButton.setName("removeScenarioButton");
        removeScenarioButton.setText(_("jmexico.action.remove.scenario"));
        removeScenarioButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeScenarioButton"));
    }

    protected void createRenameScenarioButton() {
        $objectMap.put("renameScenarioButton", renameScenarioButton = new JButton());
        
        renameScenarioButton.setName("renameScenarioButton");
        renameScenarioButton.setText(_("jmexico.action.rename.scenario"));
        renameScenarioButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__renameScenarioButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToInputDesignEditor();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(inputDesignTable);
        addChildrenToEditorToolBar();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("inputDesignEditor", inputDesignEditor);
        createHandler();
        createModel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createInputDesignTable();
        createEditorToolBar();
        createAddScenarioButton();
        createRenameScenarioButton();
        createRemoveScenarioButton();
        createCloneScenarioButton();
        createImportScenarioButton();
        createExportScenarioButton();
        // inline creation of inputDesignEditor
        setName("inputDesignEditor");
        setLayout(new BorderLayout());
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INPUT_DESIGN_TABLE_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    inputDesignTable.setModel(model.getTableModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_SCENARIO_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("inputDesign", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addScenarioButton.setEnabled(model.getInputDesign() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("inputDesign", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RENAME_SCENARIO_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("inputDesign", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    renameScenarioButton.setEnabled(model.getInputDesign() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("inputDesign", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SCENARIO_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("scenarioExists", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeScenarioButton.setEnabled(model.isScenarioExists());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("scenarioExists", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLONE_SCENARIO_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("scenarioExists", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cloneScenarioButton.setEnabled(model.isScenarioExists());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("scenarioExists", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_SCENARIO_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("inputDesign", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importScenarioButton.setEnabled(model.getInputDesign() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("inputDesign", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_SCENARIO_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("scenarioExists", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportScenarioButton.setEnabled(model.isScenarioExists());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("scenarioExists", this);
                }
            }
        });
    }

}