/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.editor;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import fr.reseaumexico.editor.AbstractScenarioModel;
import fr.reseaumexico.editor.CloneScenarioModel;
import fr.reseaumexico.editor.CloneScenarioPanel;
import fr.reseaumexico.editor.ExportScenarioModel;
import fr.reseaumexico.editor.ExportScenarioPanel;
import fr.reseaumexico.editor.ImportScenarioListener;
import fr.reseaumexico.editor.ImportScenarioModel;
import fr.reseaumexico.editor.ImportScenarioPanel;
import fr.reseaumexico.editor.InputDesignEditor;
import fr.reseaumexico.editor.MexicoDecoratorProvider;
import fr.reseaumexico.editor.factorValue.FactorValueCellEditor;
import fr.reseaumexico.editor.factorValue.FactorValueCellRenderer;
import fr.reseaumexico.editor.factorValue.FactorValueEditorFactory;
import fr.reseaumexico.model.Factor;
import fr.reseaumexico.model.InputDesign;
import fr.reseaumexico.model.Scenario;
import fr.reseaumexico.model.ScenarioImpl;
import fr.reseaumexico.model.parser.ScenarioCSVParser;
import fr.reseaumexico.model.parser.ScenarioXmlParser;
import fr.reseaumexico.model.writer.ScenarioXmlWriter;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.editor.FileEditor;
import jaxx.runtime.swing.renderer.DecoratorProviderTableCellRenderer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.DecoratorProvider;

public class InputDesignEditorHandler {
    private static final Log log = LogFactory.getLog(InputDesignEditorHandler.class);
    private final InputDesignEditor ui;
    protected Collection<ImportScenarioListener> importScenarioListeners = new LinkedList<ImportScenarioListener>();

    public InputDesignEditorHandler(InputDesignEditor ui) {
        this.ui = ui;
    }

    public void initUI() {
        this.ui.getModel().addPropertyChangeListener("inputDesign", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FactorValueEditorFactory factorValueEditorFactory = InputDesignEditorHandler.this.ui.getContextValue(FactorValueEditorFactory.class);
                if (factorValueEditorFactory != null) {
                    factorValueEditorFactory.clearCache();
                }
            }
        });
        JXTable table = this.ui.getInputDesignTable();
        table.setDefaultRenderer(Factor.class, (TableCellRenderer)new DecoratorProviderTableCellRenderer((DecoratorProvider)new MexicoDecoratorProvider()));
        table.setDefaultRenderer(Object.class, (TableCellRenderer)new FactorValueCellRenderer((JAXXContext)this.ui));
        table.setDefaultEditor(Object.class, (TableCellEditor)new FactorValueCellEditor((JAXXContext)this.ui));
    }

    public void addScenario() {
        boolean valid;
        String selectedName = JOptionPane.showInputDialog(this.ui, I18n._((String)"jmexico.label.scenario.add.name", (Object[])new Object[0]), I18n._((String)"jmexico.title.scenario.add", (Object[])new Object[0]), 3);
        boolean bl = valid = StringUtils.isNotBlank((CharSequence)selectedName) && this.isScenarioNameAvailable(selectedName);
        if (valid) {
            int maxOrder = this.getMaxOrder();
            ScenarioImpl scenarioToAdd = new ScenarioImpl();
            scenarioToAdd.setOrderNumber(maxOrder + 1);
            scenarioToAdd.setName(selectedName);
            InputDesign inputDesign = this.ui.getInputDesign();
            Collection factors = inputDesign.getExperimentDesign().getFactor();
            LinkedHashMap factorValues = Maps.newLinkedHashMap();
            for (Factor factor : factors) {
                factorValues.put(factor, null);
            }
            scenarioToAdd.setFactorValues((Map)factorValues);
            inputDesign.addScenario((Scenario)scenarioToAdd);
        }
    }

    public void removeScenario() {
        InputDesign inputDesign = this.ui.getInputDesign();
        Collection scenarios = inputDesign.getScenario();
        Scenario scenario = (Scenario)JOptionPane.showInputDialog(this.ui, I18n._((String)"jmexico.label.scenario.remove.selected", (Object[])new Object[0]), I18n._((String)"jmexico.title.scenario.remove", (Object[])new Object[0]), 3, null, scenarios.toArray(), null);
        if (scenario != null) {
            inputDesign.removeScenario(scenario);
        }
    }

    public void cloneScenario() {
        InputDesign inputDesign = this.ui.getInputDesign();
        CloneScenarioModel model = new CloneScenarioModel();
        model.setScenarios(inputDesign.getScenario());
        boolean accept = this.showCloneScenarioUI(model);
        if (accept) {
            int maxOrder = this.getMaxOrder();
            ScenarioImpl scenarioToAdd = new ScenarioImpl();
            scenarioToAdd.setOrderNumber(maxOrder + 1);
            scenarioToAdd.setName(model.getScenarioName());
            Scenario selectedScenario = model.getSelectedScenario();
            Collection factors = inputDesign.getExperimentDesign().getFactor();
            LinkedHashMap factorValues = Maps.newLinkedHashMap();
            for (Factor factor : factors) {
                Object factorValue = selectedScenario.getFactorValue(factor);
                factorValues.put(factor, factorValue);
            }
            scenarioToAdd.setFactorValues((Map)factorValues);
            inputDesign.addScenario((Scenario)scenarioToAdd);
        }
    }

    public void addScenarioImportListener(ImportScenarioListener l) {
        this.importScenarioListeners.add(l);
    }

    public void removeScenarioImportListener(ImportScenarioListener l) {
        this.importScenarioListeners.remove(l);
    }

    public void importScenario() {
        for (ImportScenarioListener l : this.importScenarioListeners) {
            l.beforeImportScenario();
        }
        InputDesign inputDesign = this.ui.getInputDesign();
        ImportScenarioModel model = new ImportScenarioModel();
        model.setScenarios(inputDesign.getScenario());
        boolean accept = this.showImportScenarioUI(model);
        if (accept) {
            File importFile = model.getImportFile();
            String scenarioName = model.getScenarioName();
            if (log.isInfoEnabled()) {
                log.info((Object)("Import scenario '" + scenarioName + "' from " + importFile));
            }
            List<Factor> factors = this.ui.getModel().getFactors();
            if (importFile.getName().endsWith("." + I18n._((String)"jmexico.config.scenario.extension.csv", (Object[])new Object[0]))) {
                this.importCSVScenario(factors, importFile, scenarioName);
            } else {
                this.importXMLScenario(factors, importFile, scenarioName);
            }
        }
        for (ImportScenarioListener l : this.importScenarioListeners) {
            l.afterImportScenario();
        }
    }

    protected void importCSVScenario(List<Factor> factors, File importFile, String scenarioName) {
        block4: {
            ImmutableMap factorsNameMap = Maps.uniqueIndex(factors, (Function)new Function<Factor, String>(){

                public String apply(Factor input) {
                    return input.getName();
                }
            });
            InputDesign inputDesign = this.ui.getInputDesign();
            ScenarioCSVParser parser = new ScenarioCSVParser((Map)factorsNameMap);
            try {
                Scenario scenario = parser.getModel(importFile);
                scenario.setName(scenarioName);
                scenario.setOrderNumber(this.getMaxOrder());
                inputDesign.addScenario(scenario);
                List unknownFactors = parser.getUnknownFactors();
                if (CollectionUtils.isNotEmpty((Collection)unknownFactors)) {
                    StringBuilder sb = new StringBuilder();
                    for (String unknownFactor : unknownFactors) {
                        sb.append("\n'").append(unknownFactor).append('\'');
                    }
                    JOptionPane.showMessageDialog(this.ui, I18n._((String)"jmexico.warning.factor.not.imported", (Object[])new Object[]{unknownFactors.size(), sb.toString()}), I18n._((String)"jmexico.title.importScenario", (Object[])new Object[0]), 2);
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not import scenario", (Throwable)e);
            }
        }
    }

    protected void importXMLScenario(List<Factor> factors, File importFile, String scenarioName) {
        block4: {
            ImmutableMap factorsMap = Maps.uniqueIndex(factors, (Function)new Function<Factor, String>(){

                public String apply(Factor input) {
                    return input.getId();
                }
            });
            InputDesign inputDesign = this.ui.getInputDesign();
            ScenarioXmlParser parser = new ScenarioXmlParser((Map)factorsMap);
            try {
                Scenario scenario = (Scenario)parser.getModel(importFile);
                scenario.setName(scenarioName);
                scenario.setOrderNumber(this.getMaxOrder());
                inputDesign.addScenario(scenario);
                List unknownFactors = parser.getUnknownFactors();
                if (CollectionUtils.isNotEmpty((Collection)unknownFactors)) {
                    StringBuilder sb = new StringBuilder();
                    for (String unknownFactor : unknownFactors) {
                        sb.append("\n'").append(unknownFactor).append('\'');
                    }
                    JOptionPane.showMessageDialog(this.ui, I18n._((String)"jmexico.warning.factor.not.imported", (Object[])new Object[]{unknownFactors.size(), sb.toString()}), I18n._((String)"jmexico.title.importScenario", (Object[])new Object[0]), 2);
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not import scenario", (Throwable)e);
            }
        }
    }

    public void exportScenario() {
        block4: {
            InputDesign inputDesign = this.ui.getInputDesign();
            ExportScenarioModel model = new ExportScenarioModel();
            model.setScenarios(inputDesign.getScenario());
            boolean accept = this.showExportScenarioUI(model);
            if (accept) {
                File exportFile = model.getExportFile(InputDesignEditorHandler.getScenarioExtension());
                Scenario scenario = model.getSelectedScenario();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Export scenario '" + scenario.getName() + "' to file " + exportFile));
                }
                try {
                    ScenarioXmlWriter.write((Scenario)scenario, (File)exportFile);
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)("Could not export scenario to " + exportFile), (Throwable)e);
                }
            }
        }
    }

    public static void onSelectedScenarioChanged(AbstractScenarioModel<?> model, ItemEvent event) {
        if (event.getStateChange() == 1) {
            Scenario item = (Scenario)event.getItem();
            model.setSelectedScenario(item);
        }
    }

    public static String getScenarioExtension() {
        return I18n._((String)"jmexico.config.scenario.extension", (Object[])new Object[0]);
    }

    protected boolean showCloneScenarioUI(CloneScenarioModel model) {
        boolean doIt;
        CloneScenarioPanel panel = new CloneScenarioPanel();
        panel.init(model);
        int response = JOptionPane.showConfirmDialog(this.ui, (Object)panel, I18n._((String)"jmexico.title.scenario.clone", (Object[])new Object[0]), 2, 3);
        boolean bl = doIt = response == 0;
        if (doIt) {
            panel.getModel().copyTo(model);
            boolean valid = true;
            Scenario selectedScenario = model.getSelectedScenario();
            if (selectedScenario == null) {
                JOptionPane.showMessageDialog(this.ui, I18n._((String)"jmexico.error.scenario.not.selected", (Object[])new Object[0]), I18n._((String)"jmexico.title.error", (Object[])new Object[0]), 0);
                valid = false;
            }
            if (valid) {
                String selectedName = model.getScenarioName();
                if (StringUtils.isBlank((CharSequence)selectedName)) {
                    valid = false;
                    JOptionPane.showMessageDialog(this.ui, I18n._((String)"jmexico.error.scenario.name.required", (Object[])new Object[0]), I18n._((String)"jmexico.title.error", (Object[])new Object[0]), 0);
                } else {
                    valid = this.isScenarioNameAvailable(selectedName);
                }
            }
            doIt = valid || this.showCloneScenarioUI(model);
        }
        return doIt;
    }

    protected boolean showExportScenarioUI(ExportScenarioModel model) {
        boolean doIt;
        ExportScenarioPanel panel = new ExportScenarioPanel();
        panel.init(model);
        FileEditor fileEditor = panel.getExportDirectoryEditor();
        fileEditor.setDirectoryEnabled(Boolean.valueOf(true));
        fileEditor.setFileEnabled(Boolean.valueOf(false));
        int response = JOptionPane.showConfirmDialog(this.ui, (Object)panel, I18n._((String)"jmexico.title.scenario.export", (Object[])new Object[0]), 2, 3);
        boolean bl = doIt = response == 0;
        if (doIt) {
            String exportFilename;
            File exportDirectory;
            panel.getModel().copyTo(model);
            boolean valid = true;
            Scenario selectedScenario = model.getSelectedScenario();
            if (selectedScenario == null) {
                JOptionPane.showMessageDialog(this.ui, I18n._((String)"jmexico.error.scenario.not.selected", (Object[])new Object[0]), I18n._((String)"jmexico.title.error", (Object[])new Object[0]), 0);
                valid = false;
            }
            if (valid && (exportDirectory = model.getExportDirectory()) == null) {
                valid = false;
                JOptionPane.showMessageDialog(this.ui, I18n._((String)"jmexico.error.scenario.exportDirectory.required", (Object[])new Object[0]), I18n._((String)"jmexico.title.error", (Object[])new Object[0]), 0);
            }
            if (valid && StringUtils.isBlank((CharSequence)(exportFilename = model.getExportFilename()))) {
                valid = false;
                JOptionPane.showMessageDialog(this.ui, I18n._((String)"jmexico.error.scenario.exportFilename.required", (Object[])new Object[0]), I18n._((String)"jmexico.title.error", (Object[])new Object[0]), 0);
            }
            doIt = valid || this.showExportScenarioUI(model);
        }
        return doIt;
    }

    protected boolean showImportScenarioUI(ImportScenarioModel model) {
        boolean doIt;
        ImportScenarioPanel panel = new ImportScenarioPanel();
        panel.init(model);
        FileEditor fileEditor = panel.getImportFileEditor();
        fileEditor.setAcceptAllFileFilterUsed(Boolean.valueOf(false));
        fileEditor.setExts(InputDesignEditorHandler.getScenarioExtension() + "," + I18n._((String)"jmexico.config.scenario.extension.csv", (Object[])new Object[0]));
        fileEditor.setExtsDescription(I18n._((String)"jmexico.config.scenario.extension.description", (Object[])new Object[0]) + "," + I18n._((String)"jmexico.config.scenario.extension.csv.description", (Object[])new Object[0]));
        int response = JOptionPane.showConfirmDialog(this.ui, (Object)panel, I18n._((String)"jmexico.title.scenario.import", (Object[])new Object[0]), 2, 3);
        boolean bl = doIt = response == 0;
        if (doIt) {
            panel.getModel().copyTo(model);
            boolean valid = true;
            File importFile = model.getImportFile();
            if (importFile == null) {
                valid = false;
                JOptionPane.showMessageDialog(this.ui, I18n._((String)"jmexico.error.scenario.importFile.required", (Object[])new Object[0]), I18n._((String)"jmexico.title.error", (Object[])new Object[0]), 0);
            }
            if (valid) {
                String selectedName = model.getScenarioName();
                if (StringUtils.isBlank((CharSequence)selectedName)) {
                    valid = false;
                    JOptionPane.showMessageDialog(this.ui, I18n._((String)"jmexico.error.scenario.name.required", (Object[])new Object[0]), I18n._((String)"jmexico.title.error", (Object[])new Object[0]), 0);
                } else {
                    valid = this.isScenarioNameAvailable(selectedName);
                }
            }
            doIt = valid || this.showImportScenarioUI(model);
        }
        return doIt;
    }

    protected int getMaxOrder() {
        int maxOrder = 0;
        Collection<Scenario> scenarios = this.ui.getModel().getScenario();
        if (CollectionUtils.isNotEmpty(scenarios)) {
            for (Scenario scenario : scenarios) {
                int orderNumber = scenario.getOrderNumber();
                maxOrder = Math.max(maxOrder, orderNumber);
            }
        }
        return maxOrder;
    }

    protected boolean isScenarioNameAvailable(String selectedName) {
        boolean result = true;
        Collection<Scenario> scenarios = this.ui.getModel().getScenario();
        if (CollectionUtils.isNotEmpty(scenarios)) {
            for (Scenario scenario : scenarios) {
                if (!selectedName.equalsIgnoreCase(scenario.getName())) continue;
                result = false;
                JOptionPane.showMessageDialog(this.ui, I18n._((String)"jmexico.error.scenario.name.used", (Object[])new Object[]{selectedName}), I18n._((String)"jmexico.title.error", (Object[])new Object[0]), 0);
                break;
            }
        }
        return result;
    }
}

