/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.peerunit.btree;

import fr.inria.peerunit.Bootstrapper;
import fr.inria.peerunit.Tester;
import fr.inria.peerunit.btreeStrategy.ConcreteBtreeStrategy;
import fr.inria.peerunit.btreeStrategy.TreeStrategy;
import fr.inria.peerunit.util.TesterUtil;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BootstrapperImpl
implements Bootstrapper,
Serializable,
Runnable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(BootstrapperImpl.class.getName());
    private TreeStrategy context;
    private TesterUtil defaults;
    private final AtomicBoolean shouldILeave = new AtomicBoolean(false);

    public BootstrapperImpl(TesterUtil tu) {
        this.defaults = tu;
        this.context = new ConcreteBtreeStrategy(this.defaults);
    }

    public void run() {
        log.entering("BootstrapperImpl", "run()");
        log.info("Starting Bootstrapper");
        try {
            this.context.waitForTesterRegistration();
            this.context.buildTree();
            this.context.setCommunication();
            this.context.startRoot();
            log.fine("Waiting fot testers to terminate");
            this.waitForTesterTermination();
            this.context.cleanUp();
            log.info("[Bootstrapper] Finished !");
        }
        catch (RemoteException ex) {
            log.log(Level.SEVERE, "Remote exception", ex);
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            log.log(Level.SEVERE, "Wait interrupted", ex);
        }
    }

    public synchronized int register(Tester t) throws RemoteException {
        log.entering("BootstrapperImpl", "register()");
        return this.context.register(t);
    }

    public int getRegistered() {
        log.entering("BootstrapperImpl", "getRegistered()");
        return this.context.getRegistered();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTesterTermination() throws InterruptedException {
        log.entering("BootstrapperImpl", "waitForTesterTermination()");
        while (!this.shouldILeave.get()) {
            AtomicBoolean atomicBoolean = this.shouldILeave;
            synchronized (atomicBoolean) {
                this.shouldILeave.wait();
            }
        }
        log.exiting("BootstrapperImpl", "waitForTesterTermination()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() throws RemoteException {
        log.entering("BootstrapperImpl", "quit()");
        AtomicBoolean atomicBoolean = this.shouldILeave;
        synchronized (atomicBoolean) {
            this.shouldILeave.set(true);
            this.shouldILeave.notifyAll();
        }
        log.exiting("BootstrapperImpl", "quit()");
    }
}

