/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.peerunit.base;

import fr.inria.peerunit.TestCase;
import fr.inria.peerunit.base.ClassFilter;
import fr.inria.peerunit.parser.AfterClassMethod;
import fr.inria.peerunit.parser.BeforeClassMethod;
import fr.inria.peerunit.parser.MethodDescription;
import fr.inria.peerunit.parser.TestStepMethod;
import fr.inria.peerunit.rmi.tester.TesterImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseWrapper {
    private static Logger LOG = Logger.getLogger(TestCaseWrapper.class.getName());
    private Map<MethodDescription, Method> methods = new TreeMap<MethodDescription, Method>();
    private List<MethodDescription> remainingMethods;
    private Object testcase;
    private int testerId = -1;
    private TesterImpl tester;

    public TestCaseWrapper(TesterImpl t) {
        assert (t != null);
        this.tester = t;
        this.testerId = this.tester.getId();
    }

    public Method getMethod(MethodDescription md) {
        return this.methods.get(md);
    }

    public void invoke(MethodDescription md) throws Throwable {
        assert (this.methods.containsKey(md)) : "Method should be registered";
        assert (this.remainingMethods.contains(md)) : "Method already executed";
        assert (this.testcase != null) : "Test Case instance should not be null";
        Method m = this.methods.get(md);
        try {
            m.invoke(this.testcase, (Object[])null);
        }
        catch (IllegalAccessException e) {
            e.fillInStackTrace();
            throw e.getCause();
        }
        catch (InvocationTargetException e) {
            e.fillInStackTrace();
            throw e.getCause();
        }
        finally {
            this.remainingMethods.remove(md);
        }
    }

    public boolean isLastMethod() {
        return this.remainingMethods.isEmpty();
    }

    public List<MethodDescription> register(Class<?> klass) {
        ClassFilter filter = new ClassFilter(klass);
        this.methods.clear();
        for (TestStepMethod testStepMethod : filter.stepMethods()) {
            if (!testStepMethod.range().includes(this.testerId)) continue;
            this.methods.put(new MethodDescription(testStepMethod), testStepMethod.method());
        }
        for (AfterClassMethod afterClassMethod : filter.afterMethods()) {
            if (!afterClassMethod.range().includes(this.testerId)) continue;
            this.methods.put(new MethodDescription(afterClassMethod), afterClassMethod.method());
        }
        for (BeforeClassMethod beforeClassMethod : filter.beforeMethods()) {
            if (!beforeClassMethod.range().includes(this.testerId)) continue;
            this.methods.put(new MethodDescription(beforeClassMethod), beforeClassMethod.method());
        }
        try {
            this.testcase = klass.newInstance();
            if (TestCase.class.isAssignableFrom(klass)) {
                ((TestCase)this.testcase).setTester(this.tester);
            }
            if (filter.setId() != null) {
                filter.setId().invoke(this.testcase, this.testerId);
            }
            if (filter.setGlobals() != null) {
                filter.setGlobals().invoke(this.testcase, this.tester.globalTable());
            }
        }
        catch (InstantiationException e) {
            LOG.log(Level.SEVERE, "Instantiation Exception", e);
        }
        catch (IllegalAccessException e) {
            LOG.log(Level.SEVERE, "Illegal Access Exception", e);
        }
        catch (IllegalArgumentException ex) {
            LOG.log(Level.SEVERE, "Illegal Argument Exception", ex);
        }
        catch (InvocationTargetException ex) {
            LOG.log(Level.SEVERE, "Invocation Target Exception", ex);
        }
        this.remainingMethods = new ArrayList<MethodDescription>(this.methods.keySet());
        return this.remainingMethods;
    }

    public Object getTestcase() {
        return this.testcase;
    }

    public Map<MethodDescription, Method> getMethods() {
        return this.methods;
    }
}

