/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.FormuleStorage;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.util.CompileHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;

public class JavadocHelper {
    private static final Log log = LogFactory.getLog(JavadocHelper.class);

    public static int generateJavadoc(JavaSourceStorage source, File destDir, boolean force, PrintWriter out) {
        File src = source.getFile();
        File dst = new File(destDir, source.getFQN().replace('.', File.separatorChar) + ".html");
        int result = 0;
        if (force || !dst.exists() || FileUtils.isFileNewer((File)src, (File)dst)) {
            result = JavadocHelper.generateJavadoc(source.getRoot(), src, destDir, out);
        }
        return result;
    }

    public static int generateJavadoc(File rootSrc, File dest, PrintWriter out) {
        List javaFiles = FileUtil.getFilteredElements((File)rootSrc, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File f) {
                boolean result = true;
                result &= f.getAbsolutePath().endsWith(".java");
                result &= !f.getAbsolutePath().startsWith(FormuleStorage.getFormuleDirectory().getAbsolutePath());
                return result &= !f.getAbsolutePath().startsWith(SimulationStorage.getSimulationDirectory().getAbsolutePath());
            }
        }, (boolean)true);
        int result = JavadocHelper.generateJavadoc(rootSrc, (Collection<File>)javaFiles, dest, out);
        return result;
    }

    public static int generateJavadoc(File rootSrc, File fileSrc, File dest, PrintWriter out) {
        int result = JavadocHelper.generateJavadoc(rootSrc, Collections.singletonList(fileSrc), dest, out);
        return result;
    }

    public static int generateJavadoc(File rootSrc, Collection<File> filesSrc, File dest, PrintWriter out) {
        int result;
        block2: {
            result = -1;
            try {
                ArrayList<File> classpath = new ArrayList<File>();
                classpath.add(rootSrc.getAbsoluteFile());
                result = JavadocHelper.generateJavadoc(classpath, filesSrc, dest, out);
            }
            catch (Exception eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Javadoc failed", (Throwable)eee);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int generateJavadoc(List<File> classpath, Collection<File> filesSrc, File dest, PrintWriter out) {
        int result = 0;
        dest.mkdirs();
        try {
            String classpathAsString = CompileHelper.getClassPathAsString(classpath);
            ArrayList<String> args = new ArrayList<String>();
            args.add("-classpath");
            args.add(classpathAsString);
            args.add("-d");
            args.add(dest.getAbsolutePath());
            args.add("-link");
            args.add("http://docs.oracle.com/javase/7/docs/api/");
            args.add("-link");
            args.add(IsisFish.config.getJavadocURL());
            args.add("-author");
            args.add("-version");
            for (File srcFile : filesSrc) {
                args.add(srcFile.getAbsolutePath());
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                File jreHome = new File(System.getProperty("java.home"));
                File jreLib = new File(jreHome.getParent(), "lib");
                File toolsJar = new File(jreLib, "tools.jar");
                URLClassLoader toolsJarLoader = new URLClassLoader(new URL[]{toolsJar.toURI().toURL()});
                Thread.currentThread().setContextClassLoader(toolsJarLoader);
                Class<?> mainTool = toolsJarLoader.loadClass("com.sun.tools.javadoc.Main");
                Method method = mainTool.getMethod("execute", String.class, PrintWriter.class, PrintWriter.class, PrintWriter.class, String.class, String[].class);
                method.invoke(null, "javadoc", out, out, out, "com.sun.tools.doclets.standard.Standard", args.toArray(new String[0]));
                toolsJarLoader.close();
            }
            catch (Exception ex) {
                out.println(I18n.t((String)"This function is only available with JDK (not JRE)", (Object[])new Object[0]));
                ex.printStackTrace(out);
                result = -1;
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        catch (Exception eee) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Can't generate javadoc", (Throwable)eee);
            }
            result = -1;
        }
        return result;
    }
}

