/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.widget.editor;

import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.ui.widget.editor.FactorEditor;
import fr.ifremer.isisfish.ui.widget.editor.FactorEditorListener;
import fr.ifremer.isisfish.ui.widget.editor.MonthComponent;
import fr.ifremer.isisfish.ui.widget.editor.StepComponent;
import fr.ifremer.isisfish.util.ConverterUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;

public class ParameterTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 6860330126841984303L;
    private static Log log = LogFactory.getLog(ParameterTableCellEditor.class);
    protected RegionStorage regionStorage = null;
    protected Component editor = null;
    protected Class<?> type = null;
    protected FactorEditorListener factorActionListener;

    public RegionStorage getRegion() {
        return this.regionStorage;
    }

    public void setRegionStorage(RegionStorage regionStorage) {
        this.regionStorage = regionStorage;
        if (regionStorage == null && log.isWarnEnabled()) {
            log.warn((Object)"setRegionStorage called with null value in parameters table cell editor");
        }
    }

    public void setFactorActionListener(FactorEditorListener factorActionListener) {
        this.factorActionListener = factorActionListener;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.type = this.getType(value, row, column);
        TypeClassMapping mapping = TypeClassMapping.getMapping(this.type);
        switch (mapping) {
            case Topia: {
                try {
                    if (this.regionStorage == null) {
                        return null;
                    }
                    TopiaContext context = this.regionStorage.getStorage().beginTransaction();
                    if (context == null) break;
                    List list = context.findAll("from " + this.type.getName(), new Object[0]);
                    JComboBox<Object> c = new JComboBox<Object>(list.toArray());
                    c.setSelectedItem(value);
                    this.editor = c;
                    context.closeContext();
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break;
                    log.warn((Object)"Can't get entity object for combobox", (Throwable)eee);
                }
                break;
            }
            case Boolean: {
                ArrayList<Boolean> listB = new ArrayList<Boolean>();
                listB.add(Boolean.TRUE);
                listB.add(Boolean.FALSE);
                JComboBox<Object> c = new JComboBox<Object>(listB.toArray());
                listB.clear();
                c.setSelectedItem(value);
                this.editor = c;
                break;
            }
            case TimeStep: {
                TimeStep date = (TimeStep)value;
                if (date == null) {
                    date = new TimeStep(0);
                }
                int month = date.getMonth().getMonthNumber();
                int yea = date.getYear();
                this.editor = new StepComponent(month, yea);
                break;
            }
            case Mounth: {
                this.editor = MonthComponent.createMounthCombo(((Month)value).getMonthNumber());
                break;
            }
            case Factor: {
                this.editor = new FactorEditor(this, (Factor)value);
                if (this.factorActionListener == null) {
                    throw new RuntimeException("Missing factorActionListener call setFactorActionListener()");
                }
                this.factorActionListener.setFactorCallback((FactorEditorListener.FactorCallback)((Object)this.editor));
                ((JButton)this.editor).addActionListener(this.factorActionListener);
                break;
            }
            default: {
                this.editor = new JTextField(String.valueOf(value));
            }
        }
        if (this.editor != null) {
            if (JComboBox.class.isInstance(this.editor)) {
                ((JComboBox)this.editor).addActionListener(this.getStopEditingListener());
            } else if (JTextField.class.isInstance(this.editor)) {
                ((JTextField)this.editor).addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Stop cell editing");
                        }
                        ParameterTableCellEditor.this.stopCellEditing();
                    }
                });
            } else if (StepComponent.class.isInstance(this.editor)) {
                StepComponent date = (StepComponent)this.editor;
                if (date.getMounthCombo() != null) {
                    date.getMounthCombo().addActionListener(this.getStopEditingListener());
                }
                if (date.getYearCombo() != null) {
                    date.getYearCombo().addActionListener(this.getStopEditingListener());
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCellEditorValue [" + this.type + "] [mapping:" + (Object)((Object)mapping) + "=" + this.editor));
        }
        return this.editor;
    }

    protected Class<?> getType(Object value, int row, int column) {
        return value.getClass();
    }

    protected ActionListener getStopEditingListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterTableCellEditor.this.stopCellEditing();
            }
        };
    }

    @Override
    public Object getCellEditorValue() {
        Object result = null;
        TopiaContext context = null;
        if (this.editor == null) {
            return "";
        }
        TypeClassMapping mapping = TypeClassMapping.getMapping(this.type);
        switch (mapping) {
            case Topia: {
                result = ((JComboBox)this.editor).getSelectedItem();
                break;
            }
            case Boolean: {
                result = ((JComboBox)this.editor).getSelectedItem();
                break;
            }
            case Mounth: {
                result = new Month(((MonthComponent)this.editor).getSelectedValue());
                break;
            }
            case TimeStep: {
                result = new TimeStep(((StepComponent)this.editor).getSelectedValue());
                break;
            }
            case Factor: {
                result = ((FactorEditor)this.editor).getFactor();
                break;
            }
            default: {
                if (this.editor instanceof JTextField) {
                    result = ((JTextField)this.editor).getText();
                    break;
                }
                if (!(this.editor instanceof JComboBox)) break;
                result = ((JComboBox)this.editor).getSelectedItem();
            }
        }
        if (result instanceof String && !String.class.equals(this.type)) {
            if (this.regionStorage != null) {
                context = this.regionStorage.getStorage();
            }
            ConvertUtilsBean cub = ConverterUtil.getConverter(context);
            result = cub.convert((String)result, this.type);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCellEditorValue [" + this.type + "] [mapping:" + (Object)((Object)mapping) + "]= " + result));
        }
        return result;
    }

    private static enum TypeClassMapping {
        Int(Integer.TYPE, Integer.class),
        Topia(TopiaEntity.class),
        Mounth(Month.class),
        TimeStep(TimeStep.class),
        Double(java.lang.Double.TYPE, Double.class),
        Boolean(java.lang.Boolean.TYPE, Boolean.class),
        Factor(Factor.class),
        File(File.class),
        String(String.class);

        private final Class<?>[] klazz;

        private TypeClassMapping(Class<?> ... klazz) {
            this.klazz = klazz;
        }

        protected static TypeClassMapping getMapping(Class<?> klazz) {
            for (TypeClassMapping t : TypeClassMapping.values()) {
                for (Class<?> loopKlazz : t.klazz) {
                    if (!loopKlazz.isAssignableFrom(klazz)) continue;
                    return t;
                }
            }
            throw new RuntimeException("could not found a TypeClassMapping for this class " + klazz);
        }
    }
}

