/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.sensitivity.model;

import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityInputUI;
import fr.ifremer.isisfish.ui.sensitivity.model.FactorTranferable;
import fr.ifremer.isisfish.ui.sensitivity.model.FactorTree;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FactorTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 5433321973795969278L;
    private static Log log = LogFactory.getLog(FactorTransferHandler.class);
    protected SensitivityInputUI sensitivityInputUI;

    public FactorTransferHandler(SensitivityInputUI sensitivityInputUI) {
        this.sensitivityInputUI = sensitivityInputUI;
    }

    @Override
    public boolean canImport(JComponent cp, DataFlavor[] df) {
        for (DataFlavor dataFlavor : df) {
            if (!dataFlavor.equals(FactorTranferable.myData)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent component, Transferable transferable) {
        boolean confirmImport = false;
        confirmImport = true;
        return confirmImport;
    }

    @Override
    protected Transferable createTransferable(JComponent cp) {
        FactorTranferable transferable = null;
        FactorTree factorTree = (FactorTree)cp;
        List<Factor> selectedFactors = factorTree.getSelectedFactors();
        if (selectedFactors != null && !selectedFactors.isEmpty()) {
            LinkedList<Factor> factors = new LinkedList<Factor>(selectedFactors);
            transferable = new FactorTranferable(factors);
        }
        return transferable;
    }

    @Override
    protected void exportDone(JComponent cp, Transferable transferable, int type) {
        block7: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Transfert done");
            }
            if (type == 2) {
                try {
                    FactorTree factorTree = (FactorTree)cp;
                    FactorGroup selectedFactorGroup = factorTree.getSelectedFactorGroup();
                    if (selectedFactorGroup != null) {
                        Object myObject = transferable.getTransferData(FactorTranferable.myData);
                        List movedFactors = (List)myObject;
                        this.sensitivityInputUI.getHandler().moveFactor(selectedFactorGroup, movedFactors);
                    }
                }
                catch (IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Exception while transfering task", (Throwable)e);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    if (!log.isErrorEnabled()) break block7;
                    log.error((Object)"Exception while transfering task", (Throwable)e);
                }
            }
        }
    }

    @Override
    public int getSourceActions(JComponent component) {
        return 2;
    }
}

