/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulationServiceListener;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityAnalysis;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityException;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.sensitivity.SensitivitySecondPassUI;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SensitivitySecondPassHandler {
    private static Log log = LogFactory.getLog(SensitivitySecondPassHandler.class);
    protected SensitivitySecondPassUI sensitivitySecondPassUI;
    protected SimulationServiceListener simulationListener;

    public SensitivitySecondPassHandler(SensitivitySecondPassUI sensitivitySecondPassUI) {
        this.sensitivitySecondPassUI = sensitivitySecondPassUI;
    }

    protected void afterInit() {
        this.simulationListener = new SimulationServiceListener(){

            @Override
            public void simulationStart(SimulationService simService, SimulationJob job) {
            }

            @Override
            public void simulationStop(SimulationService simService, SimulationJob job) {
                String masterSensitivityName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Refresh second pass UI simulations list");
                }
                GenericComboModel model = (GenericComboModel)SensitivitySecondPassHandler.this.sensitivitySecondPassUI.fieldSensitivitySimulationSelect.getModel();
                String simulationName = job.getId();
                if (simulationName.startsWith("as_") && !model.containsElement(masterSensitivityName = simulationName.substring(0, simulationName.lastIndexOf("_")))) {
                    model.addElement(masterSensitivityName);
                }
            }

            @Override
            public void clearJobDone(SimulationService simService) {
            }
        };
        SimulationService.getService().addSimulationServiceListener(this.simulationListener);
    }

    public GenericComboModel<String> getSensitivitySimulationModel() {
        ArrayList<String> asNames = new ArrayList<String>();
        for (String simulationName : SimulationStorage.getSimulationNames()) {
            String masterSensitivityName;
            if (!simulationName.startsWith("as_") || asNames.contains(masterSensitivityName = simulationName.substring(0, simulationName.lastIndexOf("_")))) continue;
            asNames.add(masterSensitivityName);
        }
        GenericComboModel<String> model = new GenericComboModel<String>(asNames);
        return model;
    }

    protected void launchSecondPass(ActionEvent event) {
        if (this.sensitivitySecondPassUI.fieldSensitivitySimulationSelect.getSelectedIndex() != -1) {
            this.runSensitivitySecondPass((String)this.sensitivitySecondPassUI.fieldSensitivitySimulationSelect.getSelectedItem());
            this.displaySensitivitySecondPass(event);
        }
    }

    protected void displaySensitivitySecondPass(ActionEvent event) {
        block4: {
            if (this.sensitivitySecondPassUI.fieldSensitivitySimulationSelect.getSelectedIndex() != -1) {
                try {
                    String selectedSimulationName = (String)this.sensitivitySecondPassUI.fieldSensitivitySimulationSelect.getSelectedItem();
                    List<File> files = this.getSensitivitySecondPassResults(selectedSimulationName);
                    String content = "";
                    for (File file : files) {
                        content = content + "Fichier " + file.getName() + "\n";
                        content = content + "------------------------------\n";
                        content = content + FileUtils.readFileToString((File)file) + "\n";
                        content = content + "\n";
                    }
                    this.sensitivitySecondPassUI.textAreaSensitivitySecondpassResult.setText(content);
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Can't run second pass", (Throwable)e);
                }
            }
        }
    }

    public void runSensitivitySecondPass(String masterSensitivitySimulationName) {
        SensitivityAnalysis sensitivityAnalysis = null;
        TreeMap<Integer, SimulationStorage> simulationStorageForAnalyze = new TreeMap<Integer, SimulationStorage>();
        File simuationDirectory = SimulationStorage.getSimulationDirectory();
        for (File simuation : simuationDirectory.listFiles()) {
            if (!simuation.isDirectory() || !simuation.getName().startsWith(masterSensitivitySimulationName + "_")) continue;
            SimulationStorage storage = SimulationStorage.getSimulation(simuation.getName());
            String suffix = simuation.getName().substring(simuation.getName().lastIndexOf("_") + 1);
            simulationStorageForAnalyze.put(Integer.valueOf(suffix), storage);
            if (sensitivityAnalysis != null) continue;
            SimulationParameter params = storage.getParameter();
            sensitivityAnalysis = params.getSensitivityAnalysis();
        }
        if (sensitivityAnalysis != null) {
            try {
                File masterExportDirectory = new File(SimulationStorage.getSensitivityResultsDirectory(), masterSensitivitySimulationName);
                if (!masterExportDirectory.isDirectory()) {
                    masterExportDirectory.mkdirs();
                }
                ArrayList<SimulationStorage> simulationStorageForAnalyzeList = new ArrayList<SimulationStorage>(simulationStorageForAnalyze.values());
                sensitivityAnalysis.analyzeResult(simulationStorageForAnalyzeList, masterExportDirectory);
            }
            catch (SensitivityException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't call analyse result", (Throwable)e);
                }
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Can't run sensitivity second pass");
        }
    }

    public List<File> getSensitivitySecondPassResults(String masterSensitivitySimulationName) {
        ArrayList<File> result = new ArrayList<File>();
        File masterExportDirectory = new File(SimulationStorage.getSensitivityResultsDirectory(), masterSensitivitySimulationName);
        if (masterExportDirectory.isDirectory()) {
            for (File exportFile : masterExportDirectory.listFiles()) {
                if (!exportFile.isFile() || exportFile.getName().startsWith(".")) continue;
                result.add(exportFile);
            }
        }
        return result;
    }
}

