/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.sensitivityexport;

import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.ui.util.RendererHelper;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

public class SensitivityExportNameListRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -4070846632975105788L;
    protected Map<String, SensitivityExport> sensitivityExportCache = new HashMap<String, SensitivityExport>();

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel c = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        String exportName = (String)value;
        String text = null;
        try {
            SensitivityExport export = this.sensitivityExportCache.get(exportName);
            if (export == null) {
                SensitivityExportStorage storage = SensitivityExportStorage.getSensitivityExport(exportName, new CodeSourceStorage.Location[0]);
                export = (SensitivityExport)storage.getNewInstance();
                this.sensitivityExportCache.put(exportName, export);
            }
            text = RendererHelper.getNameAndDocListString(exportName, export.getDescription());
        }
        catch (Exception e) {
            text = RendererHelper.getNameAndCompListString(exportName);
        }
        c.setText(text);
        return c;
    }
}

