/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.population;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.population.PopulationGroupUI;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;

public class PopulationGroupHandler
extends InputContentHandler<PopulationGroupUI> {
    private static final Log log = LogFactory.getLog(PopulationGroupHandler.class);

    protected PopulationGroupHandler(PopulationGroupUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((PopulationGroupUI)this.inputContentUI).addPropertyChangeListener("bean", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GenericComboModel<PopulationGroup> groupModel = new GenericComboModel<PopulationGroup>();
                if (evt.getNewValue() == null) {
                    ((PopulationGroupUI)PopulationGroupHandler.this.inputContentUI).setPopulationGroup(null);
                }
                if (evt.getNewValue() != null) {
                    groupModel.setElementList(((PopulationGroupUI)PopulationGroupHandler.this.inputContentUI).getBean().getPopulationGroup());
                }
                ((PopulationGroupUI)((PopulationGroupHandler)PopulationGroupHandler.this).inputContentUI).populationGroupPopulationGroupComboBox.setModel(groupModel);
            }
        });
        ((PopulationGroupUI)this.inputContentUI).addPropertyChangeListener("populationGroup", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    ((PopulationGroupUI)((PopulationGroupHandler)PopulationGroupHandler.this).inputContentUI).fieldPopulationGroupMeanWeight.setText("");
                    ((PopulationGroupUI)((PopulationGroupHandler)PopulationGroupHandler.this).inputContentUI).fieldPopulationGroupPrice.setText("");
                    ((PopulationGroupUI)((PopulationGroupHandler)PopulationGroupHandler.this).inputContentUI).fieldPopulationGroupReproductionRate.setText("");
                    ((PopulationGroupUI)((PopulationGroupHandler)PopulationGroupHandler.this).inputContentUI).fieldPopulationGroupMaturityOgive.setText("");
                    ((PopulationGroupUI)((PopulationGroupHandler)PopulationGroupHandler.this).inputContentUI).fieldPopulationGroupAge.setText("");
                    ((PopulationGroupUI)((PopulationGroupHandler)PopulationGroupHandler.this).inputContentUI).fieldPopulationGroupMinLength.setText("");
                    ((PopulationGroupUI)((PopulationGroupHandler)PopulationGroupHandler.this).inputContentUI).fieldPopulationGroupMaxLength.setText("");
                    ((PopulationGroupUI)((PopulationGroupHandler)PopulationGroupHandler.this).inputContentUI).fieldPopulationGroupComment.setText("");
                    ((PopulationGroupUI)((PopulationGroupHandler)PopulationGroupHandler.this).inputContentUI).fieldPopulationGroupNaturalDeathRate.setMatrix(null);
                }
                if (evt.getNewValue() != null) {
                    // empty if block
                }
            }
        });
    }

    protected void setNaturalDeathRateMatrix() {
        block2: {
            try {
                Population population = ((PopulationGroupUI)this.inputContentUI).getBean();
                MatrixND naturalDeathRateMatrix = population.getNaturalDeathRateMatrix();
                MatrixND naturalDeathRateMatrix2 = naturalDeathRateMatrix.getSubMatrix(0, new Object[]{((PopulationGroupUI)this.inputContentUI).getPopulationGroup()});
                ((PopulationGroupUI)this.inputContentUI).fieldPopulationGroupNaturalDeathRate.setMatrix(naturalDeathRateMatrix2.copy());
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"No zone defined for this population group", (Throwable)e);
            }
        }
    }

    protected void populationGroupChanged() {
        PopulationGroup selectedPopulationGroup = (PopulationGroup)((PopulationGroupUI)this.inputContentUI).populationGroupPopulationGroupComboBox.getSelectedItem();
        ((PopulationGroupUI)this.inputContentUI).setPopulationGroup(selectedPopulationGroup);
        if (selectedPopulationGroup != null) {
            ((PopulationGroupUI)this.inputContentUI).getSaveVerifier().addCurrentEntity(selectedPopulationGroup);
            this.setNaturalDeathRateMatrix();
        }
    }
}

